/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.io.File;
import java.util.Date;
import music.cpp.client.Album;
import music.cpp.client.Artist;
import music.cpp.client.Engine;
import music.cpp.client.GenreInfo;
import music.cpp.client.NativeEngine;
import music.cpp.client.Profile;
import music.cpp.client.Song;

public class NativeSong
implements Song {
    private long id;

    public NativeSong(long l) {
        this.id = l;
    }

    public String name() {
        return this.getName(this.id);
    }

    public String toString() {
        return this.name();
    }

    public long getID() {
        return this.id;
    }

    public boolean hasAnalysis() {
        return this.hasAnalysis(this.id);
    }

    public boolean isDead() {
        return this.isDead(this.id);
    }

    public boolean isProcessed() {
        return this.isProcessed(this.id);
    }

    public boolean getInsufficientResources() {
        return this.getInsufficientResources(this.id);
    }

    public int track() {
        return this.track(this.id);
    }

    public int year() {
        return this.year(this.id);
    }

    public int seconds() {
        return this.seconds(this.id);
    }

    public long bytes() {
        return this.bytes(this.id);
    }

    public Artist artist() {
        return NativeSong.getArtist(this.id);
    }

    public Artist composer() {
        return NativeSong.getComposer(this.id);
    }

    public Artist conductor() {
        return NativeSong.getConductor(this.id);
    }

    public Artist lyricist() {
        return NativeSong.getLyricist(this.id);
    }

    public Artist orchestra() {
        return NativeSong.getOrchestra(this.id);
    }

    public String publisher() {
        return NativeSong.getPublisher(this.id);
    }

    public Album album() {
        return NativeSong.getAlbum(this.id);
    }

    public GenreInfo genre() {
        return NativeSong.getGenre(this.id);
    }

    public File mp3() {
        return new File(this.getFile(this.id));
    }

    public Date added() {
        return new Date(this.getDateAdded(this.id) * 1000L);
    }

    public Date lastModified() {
        return new Date(this.getLastModified(this.id) * 1000L);
    }

    public boolean equals(Object object) {
        if (!(object instanceof NativeSong)) {
            return false;
        }
        NativeSong nativeSong = (NativeSong)object;
        return this.id == nativeSong.id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public void reset() {
        this.id = 0L;
    }

    public void resetStatus(Engine engine) {
        this.resetStatus(((NativeEngine)engine).getID(), this.id);
    }

    public boolean ignoreDuplicate() {
        return this.ignoreDuplicate(this.id);
    }

    public void setIgnoreDuplicate(boolean bl) {
        this.setIgnoreDuplicate(this.id, bl);
    }

    public void setCheckName(boolean bl) {
        this.setCheckName(this.id, bl);
    }

    public boolean getCheckName() {
        return this.getCheckName(this.id);
    }

    public Profile getProfile() {
        return this.getProfile(this.id);
    }

    public short[] getRawValues() {
        return this.getRawValues(this.id);
    }

    public void setLocked(boolean bl) {
        this.setLocked(this.id, bl);
    }

    public void setEnabled(boolean bl) {
        this.setEnabled(this.id, bl);
    }

    public boolean isLocked() {
        return this.isLocked(this.id);
    }

    public boolean isEnabled() {
        return this.isEnabled(this.id);
    }

    public void setRating(int n) {
        this.setRating(this.id, n);
    }

    public int getRating() {
        return this.getRating(this.id);
    }

    public boolean hasData() {
        return this.hasData(this.id);
    }

    public boolean hasPrint() {
        return this.hasPrint(this.id);
    }

    public String getField(int n) {
        return this.getField(this.id, n);
    }

    public int getBitrate() {
        return this.getBitrate(this.id);
    }

    public boolean hasImage() {
        return this.hasImage(this.id);
    }

    public void setImage(boolean bl) {
        this.setImage(this.id, bl);
    }

    private static native Artist getArtist(long var0);

    private static native Artist getComposer(long var0);

    private static native Artist getConductor(long var0);

    private static native String getPublisher(long var0);

    private static native Artist getLyricist(long var0);

    private static native Artist getOrchestra(long var0);

    private static native Album getAlbum(long var0);

    private static native GenreInfo getGenre(long var0);

    private native boolean hasAnalysis(long var1);

    private native boolean isDead(long var1);

    private native boolean isProcessed(long var1);

    private native boolean getInsufficientResources(long var1);

    private native int track(long var1);

    private native int year(long var1);

    private native int seconds(long var1);

    private native long bytes(long var1);

    private native String getFile(long var1);

    private native String getName(long var1);

    private native long getDateAdded(long var1);

    private native long getLastModified(long var1);

    private native void resetStatus(long var1, long var3);

    private native boolean ignoreDuplicate(long var1);

    private native void setIgnoreDuplicate(long var1, boolean var3);

    private native void setCheckName(long var1, boolean var3);

    private native boolean getCheckName(long var1);

    private native Profile getProfile(long var1);

    private native short[] getRawValues(long var1);

    private native void setLocked(long var1, boolean var3);

    private native boolean isLocked(long var1);

    private native void setEnabled(long var1, boolean var3);

    private native boolean isEnabled(long var1);

    private native void setRating(long var1, int var3);

    private native int getRating(long var1);

    private native boolean hasData(long var1);

    private native boolean hasPrint(long var1);

    private native String getField(long var1, int var3);

    private native int getBitrate(long var1);

    private native boolean hasImage(long var1);

    private native void setImage(long var1, boolean var3);
}

