/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.io.File;
import java.io.IOException;
import music.cpp.client.App;
import music.cpp.client.NativeCodeException;
import music.cpp.client.NativeRegistry;
import music.cpp.client.StringUtil;

public class DefaultWindowsViewer {
    private String command = null;
    private String ext = null;

    public static boolean execute(String string) {
        DefaultWindowsViewer defaultWindowsViewer = new DefaultWindowsViewer(new File(string));
        if (defaultWindowsViewer.command == null) {
            return false;
        }
        defaultWindowsViewer.open(string);
        return true;
    }

    public DefaultWindowsViewer(File file) {
        String string = file.getName();
        int n = string.indexOf(".");
        if (n > 0) {
            this.ext = string.substring(n);
            try {
                this.determineCommand();
            }
            catch (NativeCodeException nativeCodeException) {
                App.logException(nativeCodeException);
            }
        }
    }

    public String getViewer() {
        int n;
        if (this.command == null) {
            return null;
        }
        String string = null;
        int n2 = this.command.indexOf(34);
        int n3 = this.command.indexOf(34, n2 + 1);
        if (n2 == 0 && n3 > n2) {
            string = this.command.substring(1, n3);
        } else {
            n3 = this.command.indexOf(32);
            if (n3 > 0) {
                string = this.command.substring(0, n3);
            }
        }
        if (string != null && (n = string.lastIndexOf("\\")) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public void open(String string) {
        String string2;
        if (this.command == null) {
            return;
        }
        int n = this.command.indexOf("%");
        if (n == -1) {
            string2 = this.command + " " + string;
        } else if (this.command.charAt(n + 1) == '1' || this.command.charAt(n + 1) == 'l' || this.command.charAt(n + 1) == 'L') {
            string2 = this.command.substring(0, n) + string + this.command.substring(n + 2);
            if ((n = string2.indexOf("%*")) != -1) {
                string2 = string2.substring(0, n);
            }
        } else {
            string2 = this.command.substring(0, n) + string + this.command.substring(n);
        }
        try {
            Runtime.getRuntime().exec(string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void determineCommand() throws NativeCodeException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("win") || this.ext == null) {
            return;
        }
        String string = "HKEY_CLASSES_ROOT\\" + this.ext;
        String string2 = NativeRegistry.getRegistryKey(string);
        if (string2 == null) {
            return;
        }
        string = "HKEY_CLASSES_ROOT\\" + string2 + "\\shell\\open\\command";
        this.command = NativeRegistry.getRegistryKey(string);
        if (this.command == null) {
            return;
        }
        int n = this.command.indexOf(37);
        StringBuffer stringBuffer = new StringBuffer();
        while (n >= 0 && ++n < this.command.length()) {
            char c = this.command.charAt(n);
            if (Character.isLetterOrDigit(c)) {
                stringBuffer.append(c);
                continue;
            }
            if (c == '%') {
                String string3 = stringBuffer.toString();
                String string4 = this.getEnvValue(string3);
                if (string4 == null) {
                    this.command = null;
                    return;
                }
                this.command = StringUtil.replace(this.command, "%" + string3 + "%", string4);
            }
            stringBuffer = new StringBuffer();
            n = this.command.indexOf(37, n + 1);
        }
    }

    private String getEnvValue(String string) throws NativeCodeException {
        String string2 = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion";
        String string3 = NativeRegistry.getRegistryKey(string2, string);
        if (string3 == null) {
            string2 = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion";
            string3 = NativeRegistry.getRegistryKey(string2, string);
        }
        if (string3.indexOf(37) >= 0) {
            return this.getEnvValue(string3);
        }
        return string3;
    }

    public String getCommand() {
        return this.command;
    }
}

