/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.util.Iterator;
import java.util.Vector;
import music.cpp.client.MusicClient;
import music.cpp.client.Playlist;
import music.cpp.client.Song;

public class BySongs
extends Playlist {
    static final String iMusicMagicMix = MusicClient.STRINGS.get("IDSTR_PLAYLIST_MIX");
    Song[] songsLike;
    Vector positive;
    Vector negative;
    Vector exclude;
    boolean useFilters;
    int genrePreference;

    BySongs(Song[] songArray, Vector vector, boolean bl, int n) {
        super(vector);
        this.songsLike = songArray;
        this.useFilters = bl;
        this.genrePreference = n;
        this.title = iMusicMagicMix;
    }

    public void removeSong(Song song) {
        super.removeSong(song);
        if (this.songsLike != null) {
            for (int i = 0; i < this.songsLike.length; ++i) {
                int n;
                if (!song.equals(this.songsLike[i])) continue;
                Song[] songArray = new Song[this.songsLike.length - 1];
                for (n = 0; n < i; ++n) {
                    songArray[n] = this.songsLike[n];
                }
                for (n = i + 1; n < this.songsLike.length; ++n) {
                    songArray[n - 1] = this.songsLike[n];
                }
                this.songsLike = songArray;
                break;
            }
        }
        if (this.positive != null) {
            Iterator iterator = this.positive.iterator();
            while (iterator.hasNext()) {
                if (!song.equals(iterator.next())) continue;
                iterator.remove();
                break;
            }
        }
        if (this.negative != null) {
            Iterator iterator = this.negative.iterator();
            while (iterator.hasNext()) {
                if (!song.equals(iterator.next())) continue;
                iterator.remove();
                break;
            }
        }
        if (this.exclude != null) {
            Iterator iterator = this.exclude.iterator();
            while (iterator.hasNext()) {
                if (!song.equals(iterator.next())) continue;
                iterator.remove();
                break;
            }
        }
    }

    public boolean containsSeed(Song song) {
        for (int i = 0; i < this.songsLike.length; ++i) {
            if (this.songsLike[i] != song) continue;
            return true;
        }
        return false;
    }

    public boolean containsPositive(Song song) {
        if (this.positive != null) {
            return this.positive.contains(song);
        }
        return false;
    }

    public void addSeed(Song song) {
        Song[] songArray = new Song[this.songsLike.length + 1];
        for (int i = 0; i < this.songsLike.length; ++i) {
            songArray[i] = this.songsLike[i];
        }
        songArray[this.songsLike.length] = song;
        this.songsLike = songArray;
    }

    public void addPositive(Song song) {
        if (this.positive == null) {
            this.positive = new Vector();
        }
        this.positive.add(song);
    }

    public void addNegative(Song song) {
        if (this.negative == null) {
            this.negative = new Vector();
        }
        this.negative.add(song);
    }

    public void addExclusion(Song song) {
        if (this.exclude == null) {
            this.exclude = new Vector();
        }
        this.exclude.add(song);
    }

    public BySongs copy() {
        BySongs bySongs = new BySongs(this.songsLike, this.songs, this.useFilters, this.genrePreference);
        bySongs.title = this.title;
        if (this.positive != null) {
            bySongs.positive = new Vector();
            bySongs.positive.addAll(this.positive);
        }
        if (this.negative != null) {
            bySongs.negative = new Vector();
            bySongs.negative.addAll(this.negative);
        }
        if (this.exclude != null) {
            bySongs.exclude = new Vector();
            bySongs.exclude.addAll(this.exclude);
        }
        return bySongs;
    }

    public Song[] getSeed() {
        return this.songsLike;
    }
}

