/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.Gui;
import edsim51di.PeripheralMainPanel;
import edsim51di.Uart;
import edsim51di.UartAlwaysOnTopCheckboxPanel;
import edsim51di.UartFloatingFrame;
import edsim51sh.EdSim51Button;
import edsim51sh.InfoButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class UartGraphics
extends PeripheralMainPanel
implements ActionListener {
    private InfoButton infoButton = new InfoButton(this, "The data transmitted by the external UART is terminated with the \\r character (the ASCII code for \\r is 0DH).\nIn other words, when the text abc is transmitted by the UART, the actual data sent is abc\\r (or, in ASCII - 61H 62H 63H 0DH).\n\nAlternatively, a set of 8-bit numbers (written in HEX) can be transmitted. To do so, the user encloses the set in curly braces,\neach number separated by a comma. For example, {45, 7a, f5} would result in 45H 7AH F5H being transmitted.\n\nAs stared, when text is transmitted, it is terminated by 0DH. This is not the case with a set of numbers. In the above example,\nthe three bytes are sent, nothing more.\n\nSee http://www.edsim51.com/simInstructions.html#hexInUart for more information.", "EdSim51DI - External UART Information", "information");
    private JLabel baudLabel = new JLabel("8-bit UART @ ");
    private JLabel rxLabel = new JLabel("Rx");
    private JLabel txLabel = new JLabel("Tx");
    private EdSim51Button rxResetButton = new EdSim51Button("Rx Reset");
    private EdSim51Button txSendButton = new EdSim51Button("Tx Send");
    private JTextArea rxDataField = new JTextArea();
    private JTextArea txDataField = new JTextArea();
    private JScrollPane rxScrollPane;
    private JScrollPane txScrollPane;
    private String[] parityOptions = new String[]{"No Parity", "Odd Parity", "Even Parity"};
    private EdSim51Button parityButton = new EdSim51Button();
    private int[] baudRates = new int[]{19200, 4800, 2400, 1200};
    private JComboBox baudRateComboBox;
    private EdSim51Button unlockUartButton = new EdSim51Button("U");
    private UartFloatingFrame uartFloatingFrame = null;
    private Dimension uartSmall;
    private Dimension uartLarge;
    private Dimension uartDataFieldSmall = new Dimension(200, 40);
    private Dimension uartDataFieldLarge = new Dimension(300, 60);
    private boolean small;
    private Board board;
    private Gui gui;
    private Uart uart;
    private JPanel baudPanel;

    UartGraphics(Board board, Gui gui, Uart uart) {
        this.board = board;
        this.gui = gui;
        this.uart = uart;
        this.setLayout(new GridBagLayout());
        this.setToolTipText("external UART");
        Insets insets = new Insets(2, 2, 2, 2);
        this.unlockUartButton.setToolTipText("unlock the external UART pane");
        this.unlockUartButton.addActionListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        this.add((Component)this.unlockUartButton, gbc);
        this.parityButton.setText(this.parityOptions[uart.getParity()]);
        this.parityButton.setToolTipText("switch between no parity, odd parity and even parity");
        this.parityButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.parityButton, gbc);
        this.baudPanel = new JPanel();
        this.baudPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.baudPanel.add((Component)this.baudLabel, gbc);
        this.baudRateComboBox = new JComboBox<String>(this.getBaudMenu());
        this.baudRateComboBox.setSelectedIndex(this.getBaudMenuIndex(uart.getBaudRate()));
        this.baudRateComboBox.setToolTipText("select a Baud rate");
        this.baudRateComboBox.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.baudPanel.add((Component)this.baudRateComboBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 10, 0, 4);
        gbc.gridwidth = 3;
        this.add((Component)this.baudPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 10, 0, 5);
        this.add((Component)this.rxLabel, gbc);
        this.rxDataField.setEditable(false);
        this.rxDataField.setBackground(Gui.UNEDITABLE_FIELD_GREY);
        this.rxDataField.setTabSize(4);
        this.rxDataField.setToolTipText("received data");
        this.rxScrollPane = new JScrollPane(this.rxDataField);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        this.add((Component)this.rxScrollPane, gbc);
        this.rxResetButton.setToolTipText("clear the Rx window");
        this.rxResetButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.insets = insets;
        this.add((Component)this.rxResetButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 10, 0, 5);
        this.add((Component)this.txLabel, gbc);
        this.txDataField.setTabSize(4);
        this.txDataField.setToolTipText("data for transmission");
        this.txScrollPane = new JScrollPane(this.txDataField);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        this.add((Component)this.txScrollPane, gbc);
        this.txSendButton.setToolTipText("transmit text in the Tx window");
        this.txSendButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.insets = insets;
        this.add((Component)this.txSendButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.insets = insets;
        this.add((Component)this.infoButton, gbc);
        Dimension[] ds = this.initSize();
        this.uartSmall = ds[0];
        this.uartLarge = ds[1];
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.baudPanel != null) {
            this.baudPanel.setBackground(c);
        }
    }

    void addUartAlwaysOnTopCheckbox(UartAlwaysOnTopCheckboxPanel checkbox) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 10, 0, 4);
        gbc.gridwidth = 3;
        gbc.anchor = 13;
        this.add((Component)checkbox, gbc);
        this.validate();
        this.updateUI();
    }

    void removeUartAlwaysOnTopCheckbox(UartAlwaysOnTopCheckboxPanel checkbox) {
        this.remove(checkbox);
        this.validate();
        this.updateUI();
    }

    @Override
    void setSize(boolean small) {
        int fontSize;
        Dimension uartDataFieldSize;
        Dimension uartSize;
        this.small = small;
        if (this.uartFloatingFrame != null) {
            this.uartFloatingFrame.close(false);
        }
        if (small) {
            uartSize = this.uartSmall;
            uartDataFieldSize = this.uartDataFieldSmall;
            fontSize = 12;
        } else {
            uartSize = this.uartLarge;
            uartDataFieldSize = this.uartDataFieldLarge;
            fontSize = 18;
        }
        this.txSendButton.setSize("Tx Send", "Tx Reset", 1, fontSize);
        this.rxResetButton.setSize("Rx Reset", "Rx Reset", 1, fontSize);
        this.parityButton.setSize(this.parityOptions, 1, fontSize);
        this.unlockUartButton.setSize("U", "U", 1, fontSize);
        this.infoButton.setSize(small);
        Gui.setFont(this.baudRateComboBox, 1, fontSize);
        Gui.setFont(this.rxLabel, 1, fontSize);
        Gui.setFont(this.txLabel, 1, fontSize);
        Gui.setFont(this.baudLabel, 1, fontSize);
        Gui.setFont(this.txDataField, 0, fontSize);
        Gui.setFont(this.rxDataField, 0, fontSize);
        Gui.setSize(this.txScrollPane, uartDataFieldSize);
        Gui.setSize(this.rxScrollPane, uartDataFieldSize);
        Gui.setSize(this, uartSize);
    }

    JTextArea getTxDataField() {
        return this.txDataField;
    }

    JTextArea getRxDataField() {
        return this.rxDataField;
    }

    void reset() {
        this.resetTransmitter();
        this.resetReceiver();
        this.uart.setBitRateInMachineCycles();
    }

    void resetTransmitter() {
        this.uart.resetTransmitter();
        this.txSendButton.setText("Tx Send");
        this.txSendButton.setToolTipText("transmit text in the Tx window");
        this.txDataField.setEditable(true);
        this.txDataField.setBackground(Color.WHITE);
        this.txDataField.setText("");
    }

    void resetReceiver() {
        this.uart.resetReceiver();
        this.rxDataField.setText("");
    }

    private String[] getBaudMenu() {
        String[] ss = new String[this.baudRates.length];
        for (int i = 0; i < this.baudRates.length; ++i) {
            ss[i] = this.baudRates[i] + " Baud";
        }
        return ss;
    }

    private int getBaudMenuIndex(int baud) {
        for (int i = 0; i < this.baudRates.length; ++i) {
            if (baud != this.baudRates[i]) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.rxResetButton) {
            this.resetReceiver();
        } else if (event.getSource() == this.txSendButton) {
            if (this.txSendButton.getText().equals("Tx Send")) {
                if (this.txDataField.getText().equals("")) {
                    return;
                }
                this.uart.startTransmission(this.txDataField.getText());
                this.txSendButton.setText("Tx Reset");
                this.txSendButton.setToolTipText("clear the Tx window");
                this.txDataField.setEditable(false);
                this.txDataField.setBackground(Gui.UNEDITABLE_FIELD_GREY);
            } else {
                this.resetTransmitter();
            }
        } else if (event.getSource() == this.parityButton) {
            this.uart.changeParity();
            this.parityButton.setText(this.parityOptions[this.uart.getParity()]);
            this.board.setHardwareSetting("uart_parity", String.valueOf(this.uart.getParity()));
        } else if (event.getSource() == this.baudRateComboBox) {
            int baud = this.baudRates[this.baudRateComboBox.getSelectedIndex()];
            this.uart.setBaudRate(baud);
            this.board.setHardwareSetting("uart_baud", String.valueOf(baud));
        } else if (event.getSource() == this.unlockUartButton) {
            this.uartFloatingFrame = new UartFloatingFrame(this.gui, this, this.rxScrollPane, this.txScrollPane, this.unlockUartButton);
            this.uartFloatingFrame.open(this.small);
            this.board.registerAlwaysOnTopFrame(this.uartFloatingFrame);
            this.board.registerAlwaysOnTopCheckBox(this.uartFloatingFrame.getAlwaysOnTopCheckBox());
        }
    }
}

