/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.LCDCharacterStrings;
import edsim51di.LCDModuleGraphics;
import edsim51di.Peripheral;
import edsim51di.logicdiagram.LogicDiagramInterface;

class LCDModule
extends Peripheral {
    private double[] DBs = new double[]{1.7, 1.6, 1.5, 1.4, 1.3, 1.2, 1.1, 1.0};
    private double RS = 1.3;
    private double E = 1.2;
    private final int EIGHT_BIT_MODE = 0;
    private final int INTER_MODE = 1;
    private final int FOUR_BIT_MODE = 2;
    private final int ERROR = 3;
    private final int BLINK_INTERVAL = 189600;
    private int mode = 0;
    private LCDModuleGraphics lcdModuleGraphics;
    private long[] rom;
    private char[] ddRam = new char[104];
    private double bf = 0.0;
    private boolean highNibble = true;
    private boolean e;
    private boolean previousE = false;
    private boolean rs;
    private int dataBusIn;
    private int ir;
    private int dr;
    private int ddRamAddress = 0;
    private int cgRamAddress = 0;
    private boolean pointingToDdRam = true;
    private boolean increment = true;
    private boolean shift = false;
    private boolean displayOn = false;
    private boolean cursorOn = false;
    private boolean blinking = false;
    private boolean blinkInOnState = true;
    private int blinkCount = 0;
    private boolean timeToRefresh = false;
    private boolean functionSet = false;
    private int[][] DBMapping = new int[this.DBs.length][2];
    private int[] EMapping = new int[2];
    private int[] RSMapping = new int[2];
    private Board board;

    LCDModule(Board board) {
        super("LCD Module", true);
        this.board = board;
        this.clearDdRam();
        this.rom = new LCDCharacterStrings(true).getRom();
        this.lcdModuleGraphics = new LCDModuleGraphics(this.rom, this.ddRam);
        double[] d = board.getPortMapSetting("lcdModule_dbs");
        if (d != null) {
            this.DBs = d;
        }
        if ((d = board.getPortMapSetting("lcdModule_rs")) != null) {
            this.RS = d[0];
        }
        if ((d = board.getPortMapSetting("lcdModule_e")) != null) {
            this.E = d[0];
        }
        for (int DBNumber = 7; DBNumber >= 8 - this.DBs.length; --DBNumber) {
            this.DBMapping[7 - DBNumber] = this.mapDBToPortPin(DBNumber);
        }
        this.EMapping = this.mapEToPortPin();
        this.RSMapping = this.mapRSToPortPin();
    }

    @Override
    public LogicDiagramInterface[] getLogicDiagramInterfaces() {
        LogicDiagramInterface[] interfaces = new LogicDiagramInterface[10];
        int start = 546;
        for (int i = 0; i < 8; ++i) {
            interfaces[i] = new LogicDiagramInterface();
            interfaces[i].peripheralPin = start;
            if (i == 3) {
                ++interfaces[i].peripheralPin;
            }
            interfaces[i].portNumber = this.DBMapping[i][0];
            interfaces[i].pinNumber = this.DBMapping[i][1];
            start += 20;
        }
        interfaces[8] = new LogicDiagramInterface();
        interfaces[8].peripheralPin = 723;
        interfaces[8].portNumber = this.EMapping[0];
        interfaces[8].pinNumber = this.EMapping[1];
        interfaces[9] = new LogicDiagramInterface();
        interfaces[9].peripheralPin = 708;
        interfaces[9].portNumber = this.RSMapping[0];
        interfaces[9].pinNumber = this.RSMapping[1];
        return interfaces;
    }

    boolean isFourBit() {
        return this.DBs.length == 4;
    }

    void updateCgRam(int address, long data) {
        address = this.convertCgRamAddress(address);
        data &= 0x1FL;
        int characterAddress = address >> 3;
        int rowAddress = address & 7;
        data <<= rowAddress * 5;
        long character = this.rom[characterAddress];
        long newCharacter = 0L;
        long mask = 31L;
        for (int i = 0; i < 8; ++i) {
            newCharacter = i == rowAddress ? (newCharacter += data) : (newCharacter += character & mask);
            mask <<= 5;
        }
        this.rom[characterAddress] = newCharacter;
        this.rom[characterAddress + 8] = newCharacter;
    }

    LCDModuleGraphics getGraphics() {
        return this.lcdModuleGraphics;
    }

    void refreshGraphics() {
        if (this.timeToRefresh) {
            this.lcdModuleGraphics.refreshDisplay(this.cursorOn, this.blinking, this.blinkInOnState, this.ddRamAddress);
            this.timeToRefresh = false;
        }
        int ac = this.pointingToDdRam ? this.ddRamAddress : this.cgRamAddress;
        this.lcdModuleGraphics.updateTextFields((int)Math.round(this.bf), ac, this.ir, this.dr);
    }

    void reset() {
        this.mode = 0;
        this.clearDisplay();
        this.displayOn = false;
        this.cursorOn = false;
        this.blinking = false;
        this.increment = true;
        this.shift = false;
        this.bf = 0.0;
        this.ir = 0;
        this.dr = 0;
        this.ddRamAddress = 0;
        this.cgRamAddress = 0;
        this.lcdModuleGraphics.unShift();
        this.lcdModuleGraphics.turnOffDisplay();
        this.lcdModuleGraphics.refreshDisplay(this.cursorOn, this.blinking, this.blinkInOnState, this.ddRamAddress);
        this.lcdModuleGraphics.updateTextFields(0, 0, 0, 0);
        this.lcdModuleGraphics.clearErrorMessage();
    }

    void update() {
        this.setDataBus();
        this.setRS();
        this.setE();
        this.cycle();
    }

    int[][] getDBMapping() {
        return this.DBMapping;
    }

    int[] getEMapping() {
        return this.EMapping;
    }

    int[] getRSMapping() {
        return this.RSMapping;
    }

    private void setDataBus() {
        this.dataBusIn = 0;
        if (this.mode == 2 || this.mode == 1) {
            if (this.board.readPortPin(this.DBMapping[0][0], this.DBMapping[0][1]) == 1) {
                this.dataBusIn = 8;
            }
            if (this.board.readPortPin(this.DBMapping[1][0], this.DBMapping[1][1]) == 1) {
                this.dataBusIn += 4;
            }
            if (this.board.readPortPin(this.DBMapping[2][0], this.DBMapping[2][1]) == 1) {
                this.dataBusIn += 2;
            }
            if (this.board.readPortPin(this.DBMapping[3][0], this.DBMapping[3][1]) == 1) {
                ++this.dataBusIn;
            }
        } else {
            if (this.board.readPortPin(this.DBMapping[0][0], this.DBMapping[0][1]) == 1) {
                this.dataBusIn = 128;
            }
            if (this.board.readPortPin(this.DBMapping[1][0], this.DBMapping[1][1]) == 1) {
                this.dataBusIn += 64;
            }
            if (this.board.readPortPin(this.DBMapping[2][0], this.DBMapping[2][1]) == 1) {
                this.dataBusIn += 32;
            }
            if (this.board.readPortPin(this.DBMapping[3][0], this.DBMapping[3][1]) == 1) {
                this.dataBusIn += 16;
            }
            if (this.DBMapping.length == 8) {
                if (this.board.readPortPin(this.DBMapping[4][0], this.DBMapping[4][1]) == 1) {
                    this.dataBusIn += 8;
                }
                if (this.board.readPortPin(this.DBMapping[5][0], this.DBMapping[5][1]) == 1) {
                    this.dataBusIn += 4;
                }
                if (this.board.readPortPin(this.DBMapping[6][0], this.DBMapping[6][1]) == 1) {
                    this.dataBusIn += 2;
                }
                if (this.board.readPortPin(this.DBMapping[7][0], this.DBMapping[7][1]) == 1) {
                    ++this.dataBusIn;
                }
            }
        }
    }

    private void setRS() {
        this.rs = this.board.readPortPin(this.RSMapping[0], this.RSMapping[1]) == 1;
    }

    private void setE() {
        this.e = this.board.readPortPin(this.EMapping[0], this.EMapping[1]) == 1;
    }

    private void cycle() {
        if (this.mode == 3) {
            return;
        }
        if (this.blinking) {
            ++this.blinkCount;
            if (this.blinkCount == 189600) {
                this.blinkCount = 0;
                this.blinkInOnState = !this.blinkInOnState;
                this.timeToRefresh = true;
            }
        }
        if (this.bf > 0.0) {
            this.bf -= (double)this.board.getInstructionElapsedTimeInNanos() / 1000.0;
            if (this.bf <= 0.0) {
                this.bf = 0.0;
                this.timeToRefresh = true;
            }
        }
        if (this.mode == 0) {
            this.eightBitCycle();
        } else {
            this.fourBitCycle();
        }
    }

    private int[] mapDBToPortPin(int DBNumber) {
        int[] pp = new int[]{(int)this.DBs[7 - DBNumber] & 3, (int)(this.DBs[7 - DBNumber] * 10.0) % 10 & 7};
        return pp;
    }

    private int[] mapRSToPortPin() {
        int[] pp = new int[]{(int)this.RS & 3, (int)(this.RS * 10.0) % 10 & 7};
        return pp;
    }

    private int[] mapEToPortPin() {
        int[] pp = new int[]{(int)this.E & 3, (int)(this.E * 10.0) % 10 & 7};
        return pp;
    }

    private int convertCgRamAddress(int address) {
        int row = address & 7;
        row = 7 - row;
        return (address &= 0x38) + row;
    }

    private void eightBitCycle() {
        if (this.previousE && !this.e && this.bf == 0.0) {
            if (!this.rs) {
                this.ir = this.dataBusIn;
                if (this.ir >> 4 == 2) {
                    this.mode = 1;
                    this.bf = 37.0;
                } else if (this.ir >> 4 == 3) {
                    this.bf = 37.0;
                    this.functionSet();
                } else if (!this.functionSet) {
                    this.mode = 3;
                    this.lcdModuleGraphics.setErrorMessage("Error! Function set not called.");
                } else {
                    this.write();
                }
            } else if (this.functionSet) {
                this.write();
            }
        }
        this.previousE = this.e;
    }

    private void fourBitCycle() {
        if (this.previousE && !this.e && this.bf == 0.0) {
            this.write();
        }
        this.previousE = this.e;
    }

    private void write() {
        if (!this.rs) {
            if (this.mode == 2 || this.mode == 1) {
                if (this.highNibble) {
                    this.ir = this.dataBusIn << 4;
                    this.highNibble = false;
                } else {
                    this.ir += this.dataBusIn;
                    this.highNibble = true;
                    this.execute();
                }
            } else {
                this.ir = this.dataBusIn;
                this.execute();
            }
        } else if (this.mode == 2) {
            if (this.highNibble) {
                this.dr = this.dataBusIn << 4;
                this.highNibble = false;
            } else {
                this.dr += this.dataBusIn;
                this.finishWrite();
                this.highNibble = true;
            }
        } else {
            this.dr = this.dataBusIn;
            this.finishWrite();
        }
    }

    private void finishWrite() {
        this.bf = 37.0;
        if (this.pointingToDdRam) {
            this.ddRam[this.ddRamAddress] = (char)(this.dr & 0x7F);
            this.incDecDdRamAddress(this.increment);
            this.shiftDisplayAfterDdRamWrite();
        } else {
            this.updateCgRam(this.cgRamAddress, this.dr & 0x3F);
            this.incDecCgRamAddress(this.increment);
        }
    }

    private void execute() {
        this.bf = 37.0;
        if (this.mode == 1 && this.ir >> 5 == 1) {
            this.functionSet();
            return;
        }
        if (this.ir == 1) {
            this.clearDisplay();
            this.bf = 1520.0;
        } else if (this.ir == 2 || this.ir == 3) {
            this.returnHome();
            this.bf = 1520.0;
        } else if (this.ir > 3 && this.ir <= 7) {
            this.entryModeSet();
        } else if (this.ir <= 15) {
            this.displayOnOffControl();
        } else if (this.ir <= 31) {
            this.cursorOrDisplayShift();
        } else if (this.ir <= 127) {
            this.setCgRamAddress();
        } else if (this.ir <= 255) {
            this.setDdRamAddress();
        }
    }

    private void setDdRamAddress() {
        this.pointingToDdRam = true;
        int address = this.ir & 0x7F;
        if (address > 39 && address < 64) {
            address = address - 40 + 64;
        } else if (address > 103) {
            address -= 104;
        }
        this.ddRamAddress = address;
    }

    private void setCgRamAddress() {
        this.pointingToDdRam = false;
        this.cgRamAddress = this.ir & 0x3F;
    }

    private void functionSet() {
        boolean fourBit;
        int f = this.ir >> 2 & 1;
        boolean correctFont = f == 0;
        int n = this.ir >> 3 & 1;
        boolean twoLines = n == 1;
        int dl = this.ir >> 4 & 1;
        boolean bl = fourBit = dl == 0;
        if (correctFont && twoLines) {
            this.functionSet = true;
            this.mode = fourBit ? 2 : 0;
        } else {
            this.mode = 3;
            this.lcdModuleGraphics.setErrorMessage(dl, n, f);
        }
    }

    private void cursorOrDisplayShift() {
        boolean shift;
        int i = this.ir >> 2;
        boolean right = (i & 1) == 1;
        boolean bl = shift = ((i >>= 1) & 1) == 1;
        if (shift) {
            if (right) {
                this.lcdModuleGraphics.shiftRight();
            } else {
                this.lcdModuleGraphics.shiftLeft();
            }
        } else {
            this.pointingToDdRam = true;
            if (right) {
                this.incDecDdRamAddress(true);
            } else {
                this.incDecDdRamAddress(false);
            }
        }
    }

    private void displayOnOffControl() {
        int i = this.ir;
        this.blinking = (i & 1) == 1;
        this.cursorOn = ((i >>= 1) & 1) == 1;
        boolean bl = this.displayOn = ((i >>= 1) & 1) == 1;
        if (this.displayOn) {
            this.lcdModuleGraphics.turnOnDisplay();
        } else {
            this.lcdModuleGraphics.turnOffDisplay();
        }
    }

    private void entryModeSet() {
        int i = this.ir;
        this.shift = (i & 1) == 1;
        this.increment = ((i >>= 1) & 1) == 1;
    }

    private void returnHome() {
        this.ddRamAddress = 0;
        this.lcdModuleGraphics.unShift();
    }

    private void clearDisplay() {
        this.clearDdRam();
        this.ddRamAddress = 0;
        this.pointingToDdRam = true;
        this.increment = true;
        this.lcdModuleGraphics.unShift();
    }

    private void clearDdRam() {
        for (int i = 0; i < this.ddRam.length; ++i) {
            this.ddRam[i] = 32;
        }
    }

    private void shiftDisplayAfterDdRamWrite() {
        if (this.shift) {
            if (this.increment) {
                this.lcdModuleGraphics.shiftLeftIfRequired(this.ddRamAddress);
            } else {
                this.lcdModuleGraphics.shiftRightIfRequired(this.ddRamAddress);
            }
        }
    }

    private void incDecDdRamAddress(boolean increment) {
        if (increment) {
            ++this.ddRamAddress;
            if (this.ddRamAddress > 103) {
                this.ddRamAddress = 0;
            } else if (this.ddRamAddress > 39 && this.ddRamAddress < 64) {
                this.ddRamAddress = 64;
            }
        } else {
            --this.ddRamAddress;
            if (this.ddRamAddress < 0) {
                this.ddRamAddress = 103;
            } else if (this.ddRamAddress < 64 && this.ddRamAddress > 39) {
                this.ddRamAddress = 39;
            }
        }
    }

    private void incDecCgRamAddress(boolean increment) {
        if (increment) {
            ++this.cgRamAddress;
            if (this.cgRamAddress > 63) {
                this.cgRamAddress = 0;
            }
        } else {
            --this.cgRamAddress;
            if (this.cgRamAddress < 0) {
                this.cgRamAddress = 63;
            }
        }
    }
}

