/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Gui;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class LCDCharacter
extends JPanel {
    private static final int NUMBER_OF_ROWS = 8;
    private static final int NUMBER_OF_COLUMNS = 5;
    private int dotSize;
    private boolean[][] dots = new boolean[8][5];
    private long[] rom;
    private char[] ram;
    private int address;
    private boolean blank = false;
    private boolean cursorOn = false;
    private boolean blinking = false;
    private boolean blinkInOnState;
    private int ddRamAddress = 0;

    LCDCharacter(boolean small, int address, long[] rom, char[] ram) {
        this.address = address;
        this.rom = rom;
        this.ram = ram;
        this.setBorder(BorderFactory.createLineBorder(Color.WHITE, 1));
        this.setSize(small);
        this.displayCharacter(false, false, true, 0);
    }

    static int getCharacterWidth(boolean small) {
        if (small) {
            return 13;
        }
        return 18;
    }

    static int getCharacterHeight(boolean small) {
        if (small) {
            return 19;
        }
        return 27;
    }

    void setSize(boolean small) {
        this.dotSize = small ? 2 : 3;
        Dimension d = new Dimension(5 * this.dotSize + 3, 8 * this.dotSize + 3);
        Gui.setSize(this, d);
    }

    void setBlank(boolean b) {
        this.blank = b;
    }

    void setAddress(int address) {
        this.address = address;
    }

    int getAddress() {
        return this.address;
    }

    void shiftLeft() {
        ++this.address;
        if (this.address > 39 && this.address < 64) {
            this.address = 0;
        } else if (this.address > 103) {
            this.address = 64;
        }
    }

    void shiftRight() {
        --this.address;
        if (this.address < 0) {
            this.address = 39;
        } else if (this.address < 64 && this.address > 39) {
            this.address = 103;
        }
    }

    void displayCharacter(boolean cursorOn, boolean blinking, boolean blinkInOnState, int ddRamAddress) {
        this.cursorOn = cursorOn;
        this.blinking = blinking;
        this.blinkInOnState = blinkInOnState;
        this.ddRamAddress = ddRamAddress;
        char asciiValue = this.ram[this.address];
        long romValue = this.rom[asciiValue];
        String s = Long.toBinaryString(romValue);
        while (s.length() < 40) {
            s = "0" + s;
        }
        int index = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.dots[i][j] = s.charAt(index) == '1';
                ++index;
            }
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Color dotColor = Color.BLACK;
        Color backgroundColor = Color.GRAY;
        if (this.blinking && this.address == this.ddRamAddress) {
            if (this.blinkInOnState) {
                dotColor = Color.BLUE;
                backgroundColor = Color.RED;
            } else {
                dotColor = Color.RED;
                backgroundColor = Color.BLUE;
            }
        }
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.paintDot(g, i, j, dotColor, backgroundColor);
            }
        }
        if (this.cursorOn && this.address == this.ddRamAddress) {
            g.setColor(dotColor);
            for (int j = 0; j < 5; ++j) {
                g.fillRect(j * this.dotSize + this.dotSize, 7 * this.dotSize + this.dotSize, this.dotSize, this.dotSize);
            }
        }
    }

    private void paintDot(Graphics g, int row, int column, Color dotColor, Color backgroundColor) {
        if (!this.blank && this.dots[row][column]) {
            g.setColor(dotColor);
        } else {
            g.setColor(backgroundColor);
        }
        g.fillRect(column * this.dotSize + this.dotSize, row * this.dotSize + this.dotSize, this.dotSize, this.dotSize);
    }
}

