/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.ports;

import java.awt.Color;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Pin {
    private int portNumber;
    private int pinNumber;
    private Vector descriptions = new Vector();
    private JTextField field;
    private JLabel pinLabel;
    private JLabel descriptionLabel;
    private boolean connected;
    private boolean compressed = false;

    Pin(int portNumber, int pinNumber) {
        this(portNumber, pinNumber, null, null);
    }

    Pin(int portNumber, int pinNumber, String description, String toolTip) {
        this.portNumber = portNumber & 3;
        this.pinNumber = pinNumber & 7;
        this.pinLabel = new JLabel();
        this.pinLabel.setBackground(Color.BLACK);
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setBackground(Color.BLACK);
        this.setPortPinDescription(portNumber, pinNumber, description, toolTip);
        this.field = new JTextField();
        this.field.setEditable(false);
        this.field.setHorizontalAlignment(0);
        this.field.setText("1");
    }

    void setField(int bitValue) {
        this.getField().setText(String.valueOf(bitValue & 1));
    }

    void setPortPinDescription(int portNumber, int pinNumber, String description, String toolTip) {
        this.portNumber = portNumber & 3;
        this.pinNumber = pinNumber & 7;
        this.getPinLabel().setText("P" + this.getPortNumber() + "." + this.getPinNumber());
        if (description == null) {
            this.connected = false;
            description = "";
        } else {
            this.connected = true;
        }
        if (!description.equals("")) {
            description = description.trim();
            this.descriptions.add(description);
            if (this.descriptions.size() > 1) {
                description = this.descriptionLabel.getText().trim() + "|" + description;
            }
        }
        if (description.length() > 32) {
            description = this.compress();
        }
        if (description.length() > 32) {
            description = description.substring(0, 32);
        }
        description = this.pad(description);
        this.descriptionLabel.setText(description);
        if (toolTip != null && !toolTip.equals("")) {
            this.descriptionLabel.setToolTipText(toolTip);
        } else if (this.compressed) {
            this.descriptionLabel.setToolTipText(this.getDescription());
        }
    }

    public boolean isConnectedToHardware() {
        return this.connected;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public int getPinNumber() {
        return this.pinNumber;
    }

    public JTextField getField() {
        return this.field;
    }

    public JLabel getPinLabel() {
        return this.pinLabel;
    }

    public JLabel getDescriptionLabel() {
        return this.descriptionLabel;
    }

    public String[] getDescriptions() {
        String[] ss = new String[this.descriptions.size()];
        for (int i = 0; i < this.descriptions.size(); ++i) {
            ss[i] = (String)this.descriptions.elementAt(i);
        }
        return ss;
    }

    public String getDescription() {
        String s = "";
        for (int i = 0; i < this.descriptions.size(); ++i) {
            s = s + (String)this.descriptions.elementAt(i);
            if (i >= this.descriptions.size() - 1) continue;
            s = s + "|";
        }
        return this.pad(s);
    }

    public String getToolTip() {
        if (this.compressed) {
            return null;
        }
        return this.descriptionLabel.getToolTipText();
    }

    private String compress() {
        this.compressed = true;
        int extractLength = this.getLengthOfDescriptionExtract();
        String s = "";
        for (int i = 0; i < this.descriptions.size(); ++i) {
            s = s + this.getDescriptionExtract((String)this.descriptions.elementAt(i), extractLength);
            if (i >= this.descriptions.size() - 1) continue;
            s = s + "|";
        }
        return s;
    }

    private String getDescriptionExtract(String description, int length) {
        int i = description.length();
        if (i <= length) {
            return description;
        }
        if (length < 4) {
            return description.charAt(0) + "..";
        }
        String s = ".." + description.substring(i - 3, i);
        i = 0;
        String t = "";
        while (s.length() + t.length() < length) {
            t = t + description.charAt(i);
            ++i;
        }
        return t + s;
    }

    private int getLengthOfDescriptionExtract() {
        int length = 32 - (this.descriptions.size() - 1);
        return length /= this.descriptions.size();
    }

    private String pad(String s) {
        while (s.length() < 32) {
            s = s + " ";
        }
        return s;
    }
}

