/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.xch;

import edsim51sh.Memory;
import edsim51sh.instructions.xch.Xch;

public class XchdAatReg
extends Xch {
    int registerNumber;

    public XchdAatReg(int registerNumber) {
        this.mneumonic = "XCHD A,@R";
        this.registerNumber = registerNumber;
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        int a = ram.readByte(224);
        int ar = ram.readByte(ram.readRegister(this.registerNumber));
        int aLowNibble = a & 0xF;
        int arLowNibble = ar & 0xF;
        int aHighNibble = a & 0xF0;
        int arHighNibble = ar & 0xF0;
        a = aHighNibble + arLowNibble;
        ar = arHighNibble + aLowNibble;
        ram.writeByte(224, a);
        ram.writeByte(ram.readRegister(this.registerNumber), ar);
        return this.incrementPc(pc);
    }

    @Override
    public String toString() {
        return this.mneumonic + this.registerNumber;
    }

    @Override
    public int getOpcode() {
        return 214 + this.registerNumber;
    }
}

