/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.dec;

import edsim51sh.Memory;
import edsim51sh.instructions.Instruction;
import edsim51sh.instructions.dec.DecA;
import edsim51sh.instructions.dec.DecAddress;
import edsim51sh.instructions.dec.DecAtReg;
import edsim51sh.instructions.dec.DecReg;

public class Dec
extends Instruction {
    public Dec() {
        this.mneumonic = "DEC";
    }

    @Override
    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.equals("DEC A")) {
            return new DecA();
        }
        int registerNumber = mneumonic.charAt(mneumonic.length() - 1) - 48;
        if (mneumonic.startsWith("DEC R") && mneumonic.charAt(mneumonic.length() - 1) >= '0' && mneumonic.charAt(mneumonic.length() - 1) <= '7') {
            return new DecReg(registerNumber);
        }
        if (mneumonic.equals("DEC @R0") || mneumonic.equals("DEC @R1")) {
            return new DecAtReg(registerNumber);
        }
        return new DecAddress();
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        return 0;
    }

    @Override
    public int getOpcode() {
        return -1;
    }
}

