# SPDX-FileCopyrightText: 2017-2024 espeak-ng contributors
# SPDX-License-Identifier: GPL-3.0-or-later
# 
# Modified to respect USE_LIBSONIC option for Flatpak builds
#

find_library(SONIC_LIB sonic)
find_path(SONIC_INC "sonic.h")
find_library(PCAUDIO_LIB pcaudio)
find_path(PCAUDIO_INC "pcaudiolib/audio.h")
set(THREADS_PREFER_PTHREAD_FLAG ON)
find_package(Threads)
find_program(MBROLA_BIN mbrola)

include(FetchContent)

if (CMAKE_USE_PTHREADS_INIT)
  set(HAVE_PTHREAD ON)
endif(CMAKE_USE_PTHREADS_INIT)
if (MBROLA_BIN)
  set(HAVE_MBROLA ON)
endif(MBROLA_BIN)
if (SONIC_LIB AND SONIC_INC)
  set(HAVE_LIBSONIC ON)
elseif(USE_LIBSONIC)
  FetchContent_Declare(sonic-git
    GIT_REPOSITORY https://github.com/waywardgeek/sonic.git
    GIT_TAG fbf75c3d6d846bad3bb3d456cbc5d07d9fd8c104
  )
  FetchContent_MakeAvailable(sonic-git)
  FetchContent_GetProperties(sonic-git)
  add_library(sonic OBJECT ${sonic-git_SOURCE_DIR}/sonic.c)
  target_include_directories(sonic PUBLIC ${sonic-git_SOURCE_DIR})
  set(HAVE_LIBSONIC ON)
  set(SONIC_LIB sonic)
  set(SONIC_INC ${sonic-git_SOURCE_DIR})
endif()
if (PCAUDIO_LIB AND PCAUDIO_INC)
  set(HAVE_LIBPCAUDIO ON)
endif()