/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.genericeditor.ContentTypeRelatedExtensionTracker;
import org.eclipse.ui.internal.genericeditor.DefaultContentAssistProcessor;

public class GenericEditorContentAssistant
extends ContentAssistant {
    private static final DefaultContentAssistProcessor DEFAULT_CONTENT_ASSIST_PROCESSOR = new DefaultContentAssistProcessor();
    private ContentTypeRelatedExtensionTracker<IContentAssistProcessor> contentAssistProcessorTracker;
    private Set<IContentType> types;
    private List<IContentAssistProcessor> processors;

    public GenericEditorContentAssistant(ContentTypeRelatedExtensionTracker<IContentAssistProcessor> contentAssistProcessorTracker, List<IContentAssistProcessor> processors, Set<IContentType> types) {
        this(contentAssistProcessorTracker, processors, types, null);
    }

    public GenericEditorContentAssistant(ContentTypeRelatedExtensionTracker<IContentAssistProcessor> contentAssistProcessorTracker, List<IContentAssistProcessor> processors, Set<IContentType> types, IPreferenceStore preferenceStore) {
        super(true);
        this.contentAssistProcessorTracker = contentAssistProcessorTracker;
        this.processors = Objects.requireNonNullElseGet(processors, () -> Collections.emptyList());
        this.types = types;
        this.setContextInformationPopupOrientation(21);
        this.setProposalPopupOrientation(11);
        this.enableColoredLabels(true);
        if (preferenceStore != null) {
            this.enableAutoActivation(preferenceStore.getBoolean("contentAssistant.autoActivation"));
            this.setAutoActivationDelay(preferenceStore.getInt("contentAssistant.autoActivationDelay"));
            this.enableAutoActivateCompletionOnType(preferenceStore.getBoolean("contentAssistant.autoActivationOnType"));
        } else {
            this.enableAutoActivation(true);
            this.setAutoActivationDelay(10);
            this.enableAutoActivateCompletionOnType(true);
        }
        this.setInformationControlCreator((IInformationControlCreator)new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
    }

    public void updateTokens(IDocument document) {
        this.updateProcessors(document);
        this.contentAssistProcessorTracker.getTracked().stream().filter(s -> s.isPresent()).map(s -> (IContentAssistProcessor)s.get()).forEach(p -> this.updateProcessorToken((IContentAssistProcessor)p, document));
    }

    private void updateProcessors(IDocument iDocument) {
        if (this.processors.isEmpty()) {
            this.updateProcessorToken(DEFAULT_CONTENT_ASSIST_PROCESSOR, iDocument);
        } else {
            for (IContentAssistProcessor processor : this.processors) {
                this.updateProcessorToken(processor, iDocument);
            }
        }
    }

    private void updateProcessorToken(IContentAssistProcessor processor, IDocument document) {
        this.removeContentAssistProcessor(processor);
        this.addContentAssistProcessor(processor, "__dftl_partition_content_type");
        if (document != null) {
            String[] stringArray = document.getLegalContentTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                this.addContentAssistProcessor(processor, contentType);
                ++n2;
            }
        }
        if (processor != DEFAULT_CONTENT_ASSIST_PROCESSOR) {
            this.removeContentAssistProcessor(DEFAULT_CONTENT_ASSIST_PROCESSOR);
        }
    }

    public void uninstall() {
        this.contentAssistProcessorTracker.stopTracking();
        super.uninstall();
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.updateProcessors(textViewer.getDocument());
        this.contentAssistProcessorTracker.onAdd(added -> {
            IContentAssistProcessor processor;
            if (this.types.contains(added.getContentType()) && (processor = (IContentAssistProcessor)added.get()) != null) {
                this.updateProcessorToken(processor, textViewer.getDocument());
            }
        });
        this.contentAssistProcessorTracker.onRemove(removed -> {
            if (removed.isPresent()) {
                this.removeContentAssistProcessor((IContentAssistProcessor)removed.get());
            }
        });
        this.contentAssistProcessorTracker.startTracking();
    }
}

