/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.ClassButtonDialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.IDialogFieldChangeListener;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.util.JavaClassUtils;
import org.eclipse.jst.jsf.facesconfig.ui.wizard.WizardsResourcesNLS;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ManagedBeanClassSelectionPage
extends WizardPage {
    private static final int HORIZONTAL_INDENT_DEFAULT = 25;
    private String className;
    private Button searchRadioButton;
    private ClassButtonDialogField classSearchDialogField;
    private IType searchedType;
    private Button createRadioButton;
    private IProject currentProject;

    public ManagedBeanClassSelectionPage(IProject project) {
        super("JavaSelectionWizardPage");
        this.currentProject = project;
        this.setTitle(WizardsResourcesNLS.JavaSelectionWizardPage_Title);
        this.setDescription(WizardsResourcesNLS.JavaSelectionWizardPage_Description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        Group group = new Group(container, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.createSearchSection((Composite)group);
        this.createGenerateSection((Composite)group);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        this.setPageComplete(this.classSearchDialogField.getText().length() > 0);
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)container, WizardsResourcesNLS.JavaSelectionWizardPage_HelpContextID);
    }

    private void enableSearchSection(boolean enabled) {
        this.classSearchDialogField.setEnabled(enabled);
    }

    private void createSearchSection(Composite parent) {
        this.searchRadioButton = new Button(parent, 16);
        this.searchRadioButton.setText(WizardsResourcesNLS.JavaSelectionWizardPage_Search);
        this.searchRadioButton.setSelection(true);
        this.searchRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeanClassSelectionPage.this.createRadioButton.setSelection(!ManagedBeanClassSelectionPage.this.searchRadioButton.getSelection());
                ManagedBeanClassSelectionPage.this.enableSearchSection(ManagedBeanClassSelectionPage.this.searchRadioButton.getSelection());
                ManagedBeanClassSelectionPage.this.verifyComplete();
            }
        });
        Composite searchSection = new Composite(parent, 0);
        this.classSearchDialogField = new ClassButtonDialogField(this.currentProject);
        this.classSearchDialogField.setHyperLink(null);
        int numberOfControls = this.classSearchDialogField.getNumberOfControls();
        GridLayout layout = new GridLayout();
        layout.numColumns = numberOfControls;
        layout.verticalSpacing = 9;
        searchSection.setLayout((Layout)layout);
        searchSection.setLayoutData((Object)new GridData(768));
        this.classSearchDialogField.doFillIntoGrid(null, searchSection, numberOfControls);
        GridData gd = (GridData)this.classSearchDialogField.getLabelControl(null, searchSection).getLayoutData();
        gd.horizontalIndent = 25;
        this.classSearchDialogField.setLabelText(WizardsResourcesNLS.JavaSelectionWizardPage_Search_ClassName);
        LayoutUtil.setHorizontalGrabbing((Control)this.classSearchDialogField.getTextControl(null, searchSection));
        this.classSearchDialogField.setDialogFieldChangeListener(new IDialogFieldChangeListener(){

            public void dialogFieldChanged(DialogField field) {
                ManagedBeanClassSelectionPage.this.className = ManagedBeanClassSelectionPage.this.classSearchDialogField.getText();
                ManagedBeanClassSelectionPage.this.verifyComplete();
            }
        });
        Label searchDesp = new Label(searchSection, 0);
        searchDesp.setText(WizardsResourcesNLS.JavaSelectionWizardPage_Search_Description);
        gd = new GridData();
        gd.horizontalSpan = numberOfControls;
        gd.horizontalIndent = 25;
        searchDesp.setLayoutData((Object)gd);
    }

    private void createGenerateSection(Composite parent) {
        this.createRadioButton = new Button(parent, 16);
        this.createRadioButton.setText(WizardsResourcesNLS.JavaSelectionWizardPage_Create);
        this.createRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagedBeanClassSelectionPage.this.searchRadioButton.setSelection(!ManagedBeanClassSelectionPage.this.createRadioButton.getSelection());
                ManagedBeanClassSelectionPage.this.enableSearchSection(!ManagedBeanClassSelectionPage.this.createRadioButton.getSelection());
                ManagedBeanClassSelectionPage.this.verifyComplete();
            }
        });
        Composite createSection = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        createSection.setLayout((Layout)layout);
        createSection.setLayoutData((Object)new GridData(768));
        Label createDesp = new Label(createSection, 0);
        createDesp.setText(WizardsResourcesNLS.JavaSelectionWizardPage_Create_Description);
        GridData gd = new GridData();
        gd.horizontalIndent = 25;
        createDesp.setLayoutData((Object)gd);
    }

    public boolean isCreateNewJavaClass() {
        return this.createRadioButton.getSelection();
    }

    public IType getSelectedType() {
        this.searchedType = JavaClassUtils.getType(this.currentProject, this.classSearchDialogField.getText());
        return this.searchedType;
    }

    public String getClassName() {
        return this.className;
    }

    private IStatus validateJavaTypeName() {
        IStatus status = null;
        if (this.classSearchDialogField.getText().length() == 0) {
            status = new Status(4, EditorPlugin.getPluginId(), -1, NLS.bind((String)WizardsResourcesNLS.JavaSelectionWizardPage_Error_ClassIsEmpty, (Object)this.classSearchDialogField.getText()), null);
        } else {
            status = JavaConventions.validateJavaTypeName((String)this.classSearchDialogField.getText());
            if (status.getSeverity() != 4 && this.getSelectedType() == null) {
                status = new Status(4, EditorPlugin.getPluginId(), -1, NLS.bind((String)WizardsResourcesNLS.JavaSelectionWizardPage_Error_ClassIsNotDefined, (Object)this.classSearchDialogField.getText()), null);
            }
        }
        return status;
    }

    private void verifyComplete() {
        IStatus status = null;
        if (this.isCreateNewJavaClass()) {
            this.setPageComplete(true);
            this.setMessage(null);
            this.setErrorMessage(null);
        } else {
            if (this.searchRadioButton.getSelection()) {
                status = this.validateJavaTypeName();
            }
            String errorMessage = null;
            this.setPageComplete(status.getSeverity() != 4);
            if (status.getSeverity() == 4) {
                errorMessage = status.getMessage();
            }
            if (errorMessage != null) {
                this.setErrorMessage(errorMessage);
            } else {
                this.setErrorMessage(null);
            }
            if (status.getSeverity() != 0) {
                this.setMessage(status.getMessage());
            } else {
                this.setMessage(null);
            }
        }
    }
}

