/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSPUtil {
    public static String getOrCreatePrefix(IDOMModel model, String uri, String defaultPrefix) {
        String prefix = JSPUtil.getPrefix(model, uri);
        if (prefix != null) {
            return prefix;
        }
        String s = JSPUtil.findUnusedPrefix(model, defaultPrefix);
        return s;
    }

    public static String getPrefix(IDOMModel model, String uri) {
        TLDCMDocumentManager m = TaglibController.getTLDCMDocumentManager((IDocument)model.getStructuredDocument());
        if (m == null) {
            return null;
        }
        List trackers = m.getTaglibTrackers();
        Iterator iter = trackers.iterator();
        while (iter.hasNext()) {
            TaglibTracker tracker = (TaglibTracker)iter.next();
            if (uri.equals(tracker.getURI())) {
                return tracker.getPrefix();
            }
            CMDocument cmdoc = tracker.getDocument();
            if (!(cmdoc instanceof TLDDocument) || !uri.equals(((TLDDocument)cmdoc).getUri())) continue;
            return tracker.getPrefix();
        }
        return null;
    }

    public static String findUnusedPrefix(IDOMModel model, String suggestion) {
        TLDCMDocumentManager m;
        if (suggestion == null) {
            suggestion = "p";
        }
        if ((m = TaglibController.getTLDCMDocumentManager((IDocument)model.getStructuredDocument())) == null) {
            return suggestion;
        }
        List trackers = m.getTaglibTrackers();
        HashSet<String> map = new HashSet<String>();
        Iterator iter = trackers.iterator();
        while (iter.hasNext()) {
            TaglibTracker tracker = (TaglibTracker)iter.next();
            map.add(tracker.getPrefix());
        }
        if (!map.contains(suggestion)) {
            return suggestion;
        }
        int i = 1;
        while (map.contains(String.valueOf(suggestion) + i)) {
            ++i;
        }
        return String.valueOf(suggestion) + i;
    }

    public static String findURIForPrefix(IDOMModel model, String prefix) {
        if (prefix == null || model == null) {
            return null;
        }
        TLDCMDocumentManager m = TaglibController.getTLDCMDocumentManager((IDocument)model.getStructuredDocument());
        if (m == null) {
            return null;
        }
        List trackers = m.getTaglibTrackers();
        Iterator iter = trackers.iterator();
        while (iter.hasNext()) {
            TaglibTracker tracker = (TaglibTracker)iter.next();
            if (!prefix.equals(tracker.getPrefix())) continue;
            CMDocument cmdoc = tracker.getDocument();
            if (cmdoc instanceof TLDDocument) {
                return ((TLDDocument)cmdoc).getUri();
            }
            return null;
        }
        return null;
    }
}

