/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.page;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.FacesConfigEditor;
import org.eclipse.jst.jsf.facesconfig.ui.NewEditorResourcesNLS;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.OverviewComponentsSection;
import org.eclipse.jst.jsf.facesconfig.ui.section.OverviewGeneralSection;
import org.eclipse.jst.jsf.facesconfig.ui.section.OverviewManagedBeanSection;
import org.eclipse.jst.jsf.facesconfig.ui.section.OverviewNavigationSection;
import org.eclipse.jst.jsf.facesconfig.ui.section.OverviewOthersSection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class OverviewPage
extends FormPage
implements ISelectionProvider,
IFacesConfigPage {
    protected static final int LAYOUT_MARGIN_HEIGHT = 2;
    protected static final int LAYOUT_MARGIN_WIDTH = 2;
    private Object input;
    private OverviewGeneralSection generalSection;
    private OverviewManagedBeanSection beanSection;
    private OverviewComponentsSection componentsSection;
    private OverviewNavigationSection navigationSection;
    private OverviewOthersSection otherSection;

    public OverviewPage(FormEditor editor) {
        super(editor, "OverviewPage", "Overview");
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.setText(NewEditorResourcesNLS.OverviewPage_PageflowOverview_summary);
        form.setBackgroundImage(EditorPlugin.getDefault().getImage("form_banner.gif"));
        Composite body = form.getBody();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        body.setLayout((Layout)gridLayout);
        gridLayout = new GridLayout(2, true);
        form.getBody().setLayout((Layout)gridLayout);
        FormEditor editor = this.getEditor();
        FormToolkit toolkit = editor.getToolkit();
        this.generalSection = new OverviewGeneralSection(managedForm.getForm().getBody(), managedForm, this, toolkit);
        this.generalSection.initialize();
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.generalSection.getSection().setLayoutData((Object)gd);
        this.navigationSection = new OverviewNavigationSection(managedForm.getForm().getBody(), managedForm, this, toolkit);
        this.navigationSection.initialize();
        gd = new GridData(1808);
        this.navigationSection.getSection().setLayoutData((Object)gd);
        this.navigationSection.getSection().setExpanded(true);
        this.beanSection = new OverviewManagedBeanSection(managedForm.getForm().getBody(), managedForm, this, toolkit);
        this.beanSection.initialize();
        gd = new GridData(1808);
        this.beanSection.getSection().setLayoutData((Object)gd);
        this.beanSection.getSection().setExpanded(true);
        this.componentsSection = new OverviewComponentsSection(managedForm.getForm().getBody(), managedForm, this, toolkit);
        this.componentsSection.initialize();
        gd = new GridData(1808);
        this.componentsSection.getSection().setLayoutData((Object)gd);
        this.componentsSection.getSection().setExpanded(true);
        this.otherSection = new OverviewOthersSection(managedForm.getForm().getBody(), managedForm, this, toolkit);
        this.otherSection.initialize();
        gd = new GridData(1808);
        this.otherSection.getSection().setLayoutData((Object)gd);
        this.otherSection.getSection().setExpanded(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            if (this.getInput() != ((FacesConfigEditor)this.getEditor()).getFacesConfig()) {
                this.setInput(((FacesConfigEditor)this.getEditor()).getFacesConfig());
            } else {
                this.refresh();
            }
        }
    }

    public void setInput(Object input) {
        if (input instanceof FacesConfigType) {
            this.input = input;
            this.navigationSection.setInput(input);
            this.beanSection.setInput(input);
            this.componentsSection.setInput(input);
            this.otherSection.setInput(input);
        }
    }

    public void refreshAll() {
        this.generalSection.refreshAll();
        this.navigationSection.refreshAll();
        this.beanSection.refreshAll();
        this.componentsSection.refreshAll();
        this.otherSection.refreshAll();
    }

    public Object getInput() {
        return this.input;
    }

    public void refresh() {
        this.generalSection.refresh();
        this.navigationSection.refresh();
        this.beanSection.refresh();
        this.componentsSection.refresh();
        this.otherSection.refresh();
    }

    public boolean isEditor() {
        return true;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }
}

