/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.dialog;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.ClassButtonDialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.StringDialogField;
import org.eclipse.jst.jsf.facesconfig.ui.NewEditorResourcesNLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class AddEditPropertyDialog
extends Dialog {
    private static final int MIN_DIALOG_WIDTH = 300;
    private StringDialogField propertyNameField;
    private ClassButtonDialogField propertyClassField;
    private StringDialogField defaultValueField;
    private StringDialogField suggestedValueField;
    private IProject project;
    private boolean isNew;
    private String propertyName;
    private String propertyClass;
    private String defaultValue;
    private String suggestedValue;

    public AddEditPropertyDialog(Shell parentShell, boolean isNew) {
        super(parentShell);
        this.isNew = isNew;
    }

    public AddEditPropertyDialog(Shell parentShell, String propertyName, String propertyClass, String defaultValue, String suggestedValue) {
        super(parentShell);
        this.propertyName = propertyName;
        this.propertyClass = propertyClass;
        this.defaultValue = defaultValue;
        this.suggestedValue = suggestedValue;
        this.isNew = false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isNew) {
            newShell.setText(NewEditorResourcesNLS.PropertySection_Dialog_Title_Add);
        } else {
            newShell.setText(NewEditorResourcesNLS.PropertySection_Dialog_Title_Edit);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        TabFolder tabFolder = new TabFolder(container, 4);
        tabFolder.setLayoutData((Object)gd);
        TabItem generalTabItem = new TabItem(tabFolder, 0);
        generalTabItem.setText(NewEditorResourcesNLS.PropertySection_Dialog_Tab_General);
        Control control = this.createGeneralTabControl((Composite)generalTabItem.getParent());
        generalTabItem.setControl(control);
        return container;
    }

    private Control createGeneralTabControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        this.propertyNameField = new StringDialogField();
        this.propertyNameField.setLabelText(NewEditorResourcesNLS.PropertySection_Dialog_PropertyName);
        this.propertyClassField = new ClassButtonDialogField(this.getProject());
        this.propertyClassField.setLabelText(NewEditorResourcesNLS.PropertySection_Dialog_PropertyClass);
        this.propertyClassField.setAutoOpenResource(false);
        this.defaultValueField = new StringDialogField();
        this.defaultValueField.setLabelText(NewEditorResourcesNLS.PropertySection_Dialog_DefaultValue);
        this.suggestedValueField = new StringDialogField();
        this.suggestedValueField.setLabelText(NewEditorResourcesNLS.PropertySection_Dialog_SuggestedValue);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        int numberOfColumns = 4;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        composite.setLayout((Layout)gl);
        this.propertyNameField.doFillIntoGrid(null, composite, numberOfColumns);
        this.propertyClassField.doFillIntoGrid(null, composite, numberOfColumns);
        this.defaultValueField.doFillIntoGrid(null, composite, numberOfColumns);
        this.suggestedValueField.doFillIntoGrid(null, composite, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.propertyClassField.getTextControl(null, composite));
        this.propertyNameField.setText(this.propertyName);
        this.propertyClassField.setText(this.propertyClass);
        this.defaultValueField.setText(this.defaultValue);
        this.suggestedValueField.setText(this.suggestedValue);
        return composite;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(300), shellSize.x), shellSize.y);
    }

    protected IProject getProject() {
        return this.project;
    }

    protected void okPressed() {
        this.propertyName = this.propertyNameField.getText();
        this.propertyClass = this.propertyClassField.getText();
        this.defaultValue = this.defaultValueField.getText();
        this.suggestedValue = this.suggestedValueField.getText();
        super.okPressed();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getPropertyClass() {
        return this.propertyClass;
    }

    public void setPropertyClass(String propertyClass) {
        this.propertyClass = propertyClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getSuggestedValue() {
        return this.suggestedValue;
    }

    public void setSuggestedValue(String suggestedValue) {
        this.suggestedValue = suggestedValue;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

