/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.completers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.shell.CommandCompleter;

public class PackageCompleter
implements CommandCompleter {
    private static final String SUBCOMMAND_LIST = "list";
    private QuasiFrameworkFactory quasiFrameworkFactory;

    public PackageCompleter(QuasiFrameworkFactory quasiFrameworkFactory) {
        this.quasiFrameworkFactory = quasiFrameworkFactory;
    }

    @Override
    public List<String> getCompletionCandidates(String subcommand, String ... tokens) {
        Set<Object> candidates = SUBCOMMAND_LIST.equals(subcommand) ? Collections.emptySet() : (tokens.length == 2 ? this.versions(tokens[0], tokens[1]) : (tokens.length == 1 ? this.names(tokens[0]) : Collections.emptySet()));
        ArrayList<String> candidateList = new ArrayList<String>(candidates);
        Collections.sort(candidateList);
        return candidateList;
    }

    private Set<String> versions(String name, String version) {
        HashSet<String> versions = new HashSet<String>();
        for (QuasiExportPackage exportPackage : this.getAllPackages()) {
            String packageName = exportPackage.getPackageName();
            String packageVersion = exportPackage.getVersion().toString();
            if (!packageName.equals(name) || !packageVersion.startsWith(version)) continue;
            versions.add(packageVersion);
        }
        return versions;
    }

    private Set<String> names(String name) {
        HashSet<String> names = new HashSet<String>();
        for (QuasiExportPackage exportPackage : this.getAllPackages()) {
            String packageName = exportPackage.getPackageName();
            if (!packageName.startsWith(name)) continue;
            names.add(packageName);
        }
        return names;
    }

    private List<QuasiExportPackage> getAllPackages() {
        ArrayList<QuasiExportPackage> packages = new ArrayList<QuasiExportPackage>();
        for (QuasiBundle bundle : this.quasiFrameworkFactory.create().getBundles()) {
            packages.addAll(bundle.getExportPackages());
        }
        return packages;
    }
}

