/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.jdbc.ClientBaseDataSource;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derby.jdbc.ClientDriver;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class ClientConnectionPoolDataSource
extends ClientDataSource
implements ConnectionPoolDataSource {
    private static final long serialVersionUID = -539234282156481377L;
    private static final MessageUtil msgUtil = new MessageUtil("org.apache.derby.loc.clientmessages");
    public static final String className__ = "org.apache.derby.jdbc.ClientConnectionPoolDataSource";
    private int maxStatements = 0;

    public PooledConnection getPooledConnection() throws SQLException {
        LogWriter logWriter = null;
        try {
            this.updateDataSourceValues(ClientConnectionPoolDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            logWriter = super.computeDncLogWriterForNewConnection("_cpds");
            if (logWriter != null) {
                logWriter.traceEntry(this, "getPooledConnection");
            }
            PooledConnection pooledConnection = this.getPooledConnectionX(logWriter, this, this.getUser(), this.getPassword());
            if (logWriter != null) {
                logWriter.traceExit((Object)this, "getPooledConnection", pooledConnection);
            }
            return pooledConnection;
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(logWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        LogWriter logWriter = null;
        try {
            this.updateDataSourceValues(ClientConnectionPoolDataSource.tokenizeAttributes(this.getConnectionAttributes(), null));
            logWriter = super.computeDncLogWriterForNewConnection("_cpds");
            if (logWriter != null) {
                logWriter.traceEntry((Object)this, "getPooledConnection", (Object)string, (Object)"<escaped>");
            }
            PooledConnection pooledConnection = this.getPooledConnectionX(logWriter, this, string, string2);
            if (logWriter != null) {
                logWriter.traceExit((Object)this, "getPooledConnection", pooledConnection);
            }
            return pooledConnection;
        }
        catch (SqlException sqlException) {
            this.handleConnectionException(logWriter, sqlException);
            throw sqlException.getSQLException();
        }
    }

    private PooledConnection getPooledConnectionX(LogWriter logWriter, ClientBaseDataSource clientBaseDataSource, String string, String string2) throws SQLException {
        return ClientDriver.getFactory().newClientPooledConnection(clientBaseDataSource, logWriter, string, string2);
    }

    public void setMaxStatements(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(msgUtil.getTextMessage("J134", new Integer(n)));
        }
        this.maxStatements = n;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public int maxStatementsToPool() {
        return this.maxStatements;
    }

    private final void validateState() {
        if (this.maxStatements < 0) {
            throw new IllegalArgumentException(msgUtil.getTextMessage("J134", new Integer(this.maxStatements)));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.validateState();
    }
}

