/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.library.internal;

import java.net.URI;
import java.util.List;
import java.util.Set;
import org.eclipse.virgo.kernel.artifact.library.LibraryBridge;
import org.eclipse.virgo.kernel.artifact.library.LibraryDefinition;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.Attribute;
import org.eclipse.virgo.util.osgi.manifest.ImportedBundle;
import org.osgi.framework.Version;

public final class ArtifactDescriptorLibraryDefinition
implements LibraryDefinition {
    private final String description;
    private final String name;
    private final URI location;
    private final Version version;
    private final String symbolicName;
    private final List<ImportedBundle> importedBundles;

    public ArtifactDescriptorLibraryDefinition(ArtifactDescriptor artifactDescriptor) {
        Set descriptionSet = artifactDescriptor.getAttribute("Library-Description");
        this.description = !descriptionSet.isEmpty() ? ((Attribute)descriptionSet.iterator().next()).getValue() : null;
        Set nameSet = artifactDescriptor.getAttribute("Library-Name");
        this.name = !nameSet.isEmpty() ? ((Attribute)nameSet.iterator().next()).getValue() : null;
        this.location = artifactDescriptor.getUri();
        Set versionSet = artifactDescriptor.getAttribute("Library-Version");
        this.version = new Version(((Attribute)versionSet.iterator().next()).getValue());
        Set symbolicNameSet = artifactDescriptor.getAttribute("Library-SymbolicName");
        Attribute symbolicNameAttribute = (Attribute)symbolicNameSet.iterator().next();
        this.symbolicName = symbolicNameAttribute.getValue();
        String importBundleHeader = ((Attribute)artifactDescriptor.getAttribute("RAW_HEADER:Import-Bundle").iterator().next()).getValue();
        this.importedBundles = LibraryBridge.parseImportBundle(importBundleHeader);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<ImportedBundle> getLibraryBundles() {
        return this.importedBundles;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public URI getLocation() {
        return this.location;
    }
}

