/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.quasi;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.virgo.kernel.artifact.plan.PlanDescriptor;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiRequiredBundle;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiExportPackage;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiImportPackage;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiRequiredBundle;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

final class StandardQuasiBundle
implements QuasiBundle {
    private final BundleDescription bundleDescription;
    private final BundleManifest bundleManifest;
    private volatile Bundle bundle;
    private final String bsn;
    private Version bv;
    private final StateHelper stateHelper;
    private volatile PlanDescriptor.Provisioning provisioning = PlanDescriptor.Provisioning.AUTO;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public StandardQuasiBundle(BundleDescription bundleDescription, BundleManifest bundleManifest, StateHelper stateHelper) {
        this.bundleDescription = bundleDescription;
        this.bundleManifest = bundleManifest;
        this.bsn = bundleDescription.getSymbolicName();
        this.bv = bundleDescription.getVersion();
        this.stateHelper = stateHelper;
    }

    BundleDescription getBundleDescription() {
        return this.bundleDescription;
    }

    BundleManifest getBundleManifest() {
        return this.bundleManifest;
    }

    public String getSymbolicName() {
        return this.bundleDescription.getSymbolicName();
    }

    public Version getVersion() {
        return this.bundleDescription.getVersion();
    }

    public boolean isResolved() {
        return this.bundleDescription.isResolved();
    }

    public void uninstall() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String toString() {
        return "QuasiBundle(" + this.getSymbolicName() + ", " + this.getVersion() + ")";
    }

    public long getBundleId() {
        return this.bundleDescription.getBundleId();
    }

    public List<QuasiBundle> getFragments() {
        BundleDescription[] fragments = this.bundleDescription.getFragments();
        return this.wrapBundleDescriptions(fragments);
    }

    public List<QuasiBundle> getHosts() {
        HostSpecification hostSpecification = this.bundleDescription.getHost();
        return hostSpecification == null ? null : this.wrapBundleDescriptions(hostSpecification.getHosts());
    }

    public List<QuasiExportPackage> getExportPackages() {
        ExportPackageDescription[] exportPackages = this.bundleDescription.getExportPackages();
        return this.wrapExportPackageDescriptions(exportPackages);
    }

    public List<QuasiImportPackage> getImportPackages() {
        return this.wrapImportPackageSpecifications(this.bundleDescription.getImportPackages());
    }

    public List<QuasiRequiredBundle> getRequiredBundles() {
        return this.wrapBundleSpecificationsAsRequiredBundles(this.bundleDescription.getRequiredBundles());
    }

    public List<QuasiBundle> getDependents() {
        BundleDescription[] dependents = this.bundleDescription.getDependents();
        return this.wrapBundleDescriptions(dependents);
    }

    private List<QuasiBundle> wrapBundleDescriptions(BundleDescription[] bundleDescriptions) {
        ArrayList<StandardQuasiBundle> quasiBundles = new ArrayList<StandardQuasiBundle>();
        BundleDescription[] bundleDescriptionArray = bundleDescriptions;
        int n = bundleDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundleDescription = bundleDescriptionArray[n2];
            quasiBundles.add(new StandardQuasiBundle(bundleDescription, null, this.stateHelper));
            ++n2;
        }
        return Collections.unmodifiableList(quasiBundles);
    }

    private List<QuasiRequiredBundle> wrapBundleSpecificationsAsRequiredBundles(BundleSpecification[] bundleDescriptions) {
        ArrayList<StandardQuasiRequiredBundle> quasiRequiredBundles = new ArrayList<StandardQuasiRequiredBundle>();
        BundleSpecification[] bundleSpecificationArray = bundleDescriptions;
        int n = bundleDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification bundleSpecification = bundleSpecificationArray[n2];
            quasiRequiredBundles.add(new StandardQuasiRequiredBundle(bundleSpecification, this));
            ++n2;
        }
        return Collections.unmodifiableList(quasiRequiredBundles);
    }

    private List<QuasiExportPackage> wrapExportPackageDescriptions(ExportPackageDescription[] exportPackageDescriptions) {
        ArrayList<StandardQuasiExportPackage> quasiExportPackages = new ArrayList<StandardQuasiExportPackage>();
        ExportPackageDescription[] exportPackageDescriptionArray = exportPackageDescriptions;
        int n = exportPackageDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription exportPackageDescription = exportPackageDescriptionArray[n2];
            quasiExportPackages.add(new StandardQuasiExportPackage(exportPackageDescription, this));
            ++n2;
        }
        return Collections.unmodifiableList(quasiExportPackages);
    }

    private List<QuasiImportPackage> wrapImportPackageSpecifications(ImportPackageSpecification[] importPackageSpecifications) {
        ArrayList<StandardQuasiImportPackage> quasiImportPackages = new ArrayList<StandardQuasiImportPackage>();
        ImportPackageSpecification[] importPackageSpecificationArray = importPackageSpecifications;
        int n = importPackageSpecifications.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification importPackageSpecification = importPackageSpecificationArray[n2];
            quasiImportPackages.add(new StandardQuasiImportPackage(importPackageSpecification, this));
            ++n2;
        }
        return Collections.unmodifiableList(quasiImportPackages);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.bsn == null ? 0 : this.bsn.hashCode());
        result = 31 * result + (this.bv == null ? 0 : this.bv.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardQuasiBundle other = (StandardQuasiBundle)obj;
        if (this.bsn == null ? other.bsn != null : !this.bsn.equals(other.bsn)) {
            return false;
        }
        return !(this.bv == null ? other.bv != null : !this.bv.equals((Object)other.bv));
    }

    public StateHelper getStateHelper() {
        return this.stateHelper;
    }

    public File getBundleFile() {
        BundleHost bh;
        BundleData bundleData;
        if (this.bundle instanceof BundleHost && (bundleData = (bh = (BundleHost)this.bundle).getBundleData()) instanceof BaseData) {
            File file = ((BaseData)bundleData).getBundleFile().getBaseFile();
            return file;
        }
        return null;
    }

    public void setProvisioning(PlanDescriptor.Provisioning provisioning) {
        if (provisioning == null) {
            throw new IllegalArgumentException("null not a valid provisioning behaviour for a QuasiBundle");
        }
        if (provisioning == PlanDescriptor.Provisioning.INHERIT) {
            throw new IllegalArgumentException("INHERIT is not a valid provisioning behaviour for a QuasiBundle");
        }
        this.provisioning = provisioning;
    }

    public PlanDescriptor.Provisioning getProvisioning() {
        return this.provisioning;
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiBundle");
    }
}

