/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.ByteArrayEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.HttpConnection;

public class LocalConnector
extends AbstractConnector {
    private final BlockingQueue<Request> _requests = new LinkedBlockingQueue<Request>();

    public LocalConnector() {
        this.setMaxIdleTime(30000);
    }

    public Object getConnection() {
        return this;
    }

    public String getResponses(String requests) throws Exception {
        return this.getResponses(requests, false);
    }

    public String getResponses(String requests, boolean keepOpen) throws Exception {
        ByteArrayBuffer result = this.getResponses(new ByteArrayBuffer(requests, "ISO-8859-1"), keepOpen);
        return result == null ? null : result.toString("ISO-8859-1");
    }

    public ByteArrayBuffer getResponses(ByteArrayBuffer requestsBuffer, boolean keepOpen) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        Request request = new Request(requestsBuffer, keepOpen, latch);
        this._requests.add(request);
        latch.await(this.getMaxIdleTime(), TimeUnit.MILLISECONDS);
        return request.getResponsesBuffer();
    }

    protected void accept(int acceptorID) throws IOException, InterruptedException {
        Request request = this._requests.take();
        this.getThreadPool().dispatch((Runnable)request);
    }

    public void open() throws IOException {
    }

    public void close() throws IOException {
    }

    public int getLocalPort() {
        return -1;
    }

    public void executeRequest(String rawRequest) throws IOException {
        Request request = new Request(new ByteArrayBuffer(rawRequest, "UTF-8"), true, null);
        this._requests.add(request);
    }

    private class Request
    implements Runnable {
        private final ByteArrayBuffer _requestsBuffer;
        private final boolean _keepOpen;
        private final CountDownLatch _latch;
        private volatile ByteArrayBuffer _responsesBuffer;

        private Request(ByteArrayBuffer requestsBuffer, boolean keepOpen, CountDownLatch latch) {
            this._requestsBuffer = requestsBuffer;
            this._keepOpen = keepOpen;
            this._latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block12: {
                    ByteArrayEndPoint endPoint;
                    block10: {
                        endPoint = new ByteArrayEndPoint(this._requestsBuffer.asArray(), 1024){

                            public void setConnection(Connection connection) {
                                LocalConnector.this.connectionUpgraded(this.getConnection(), connection);
                                super.setConnection(connection);
                            }
                        };
                        endPoint.setGrowOutput(true);
                        HttpConnection connection = new HttpConnection(LocalConnector.this, (EndPoint)endPoint, LocalConnector.this.getServer());
                        endPoint.setConnection((Connection)connection);
                        LocalConnector.this.connectionOpened(connection);
                        boolean leaveOpen = this._keepOpen;
                        try {
                            try {
                                while (endPoint.getIn().length() > 0 && endPoint.isOpen()) {
                                    Connection con;
                                    Connection next;
                                    while ((next = (con = endPoint.getConnection()).handle()) != con) {
                                        endPoint.setConnection(next);
                                    }
                                }
                                Object var7_7 = null;
                                if (leaveOpen) break block10;
                            }
                            catch (Exception x) {
                                leaveOpen = false;
                                Object var7_8 = null;
                                if (!leaveOpen) {
                                    LocalConnector.this.connectionClosed(connection);
                                }
                                this._responsesBuffer = endPoint.getOut();
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_9 = null;
                            if (!leaveOpen) {
                                LocalConnector.this.connectionClosed(connection);
                            }
                            this._responsesBuffer = endPoint.getOut();
                            throw throwable;
                        }
                        LocalConnector.this.connectionClosed(connection);
                    }
                    this._responsesBuffer = endPoint.getOut();
                }
                Object var9_11 = null;
                if (this._latch == null) return;
                this._latch.countDown();
                return;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (this._latch == null) throw throwable;
                this._latch.countDown();
                throw throwable;
            }
        }

        public ByteArrayBuffer getResponsesBuffer() {
            return this._responsesBuffer;
        }
    }
}

