/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.parsing;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.shell.internal.parsing.ParsedCommand;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.common.StringUtils;

public class ParsingUtils {
    private static final String DELIMITER = " ";
    private static final String EMPTY_STRING = "";
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public static ParsedCommand parseCommand(CharSequence command) {
        try {
            ParsedCommand parsedCommand;
            ParsingUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            String commandString = command.toString();
            String[] tokens = StringUtils.tokenizeToStringArray((String)commandString, (String)DELIMITER);
            if (tokens.length == 0) {
                parsedCommand = null;
            } else {
                String commandName = tokens[0];
                String[] arguments = ParsingUtils.getArguments(commandString.substring(commandName.length()));
                parsedCommand = new ParsedCommand(commandName, arguments);
            }
            ParsingUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return parsedCommand;
        }
        catch (Throwable throwable) {
            ParsingUtils.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private static String[] getArguments(String buffer) {
        ArrayList<String> arguments = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(buffer, DELIMITER, true);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (DELIMITER.equals(token)) {
                if (tokenizer.hasMoreElements()) continue;
                arguments.add(EMPTY_STRING);
                continue;
            }
            arguments.add(token);
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    static {
        Factory factory = new Factory("ParsingUtils.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.parsing.ParsingUtils"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "parseCommand", "org.eclipse.virgo.kernel.shell.internal.parsing.ParsingUtils", "java.lang.CharSequence:", "command:", EMPTY_STRING, "org.eclipse.virgo.kernel.shell.internal.parsing.ParsedCommand"), 45);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.parsing.ParsingUtils");
    }
}

