/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Iterator;
import java.util.Map;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConversionUtils {
    ConversionUtils() {
    }

    public static Object invokeConverter(GenericConverter converter, Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return converter.convert(source, sourceType, targetType);
        }
        catch (ConversionFailedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionFailedException(sourceType, targetType, source, ex);
        }
    }

    public static TypeDescriptor[] getMapEntryTypes(Map<?, ?> sourceMap) {
        Class<?> keyType = null;
        Class<?> valueType = null;
        Iterator<Map.Entry<?, ?>> iterator = sourceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry;
            Map.Entry<?, ?> mapEntry = entry = iterator.next();
            Object key = mapEntry.getKey();
            if (keyType == null && key != null) {
                keyType = key.getClass();
            }
            Object value = mapEntry.getValue();
            if (valueType == null && value != null) {
                valueType = value.getClass();
            }
            if (keyType != null && valueType != null) break;
        }
        return new TypeDescriptor[]{TypeDescriptor.valueOf(keyType), TypeDescriptor.valueOf(valueType)};
    }
}

