/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.ui.modelconnector;

import java.util.Optional;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorPart;
import org.eclipse.viatra.query.runtime.ui.ViatraQueryRuntimeUIPlugin;
import org.eclipse.viatra.query.runtime.ui.modelconnector.IModelConnector;

public class AdapterUtil {
    private static ILog logger = ViatraQueryRuntimeUIPlugin.getDefault().getLog();

    public static IModelConnector getModelConnectorFromIEditorPart(IEditorPart editorPart) {
        if (editorPart != null) {
            Object adaptedObject = editorPart.getAdapter(IModelConnector.class);
            if (adaptedObject != null) {
                return (IModelConnector)adaptedObject;
            }
            Platform.getAdapterManager().loadAdapter((Object)editorPart, IModelConnector.class.getName());
            adaptedObject = editorPart.getAdapter(IModelConnector.class);
            if (adaptedObject != null) {
                return (IModelConnector)adaptedObject;
            }
            logger.log((IStatus)new Status(4, "org.eclipse.viatra.query.runtime.ui", "EditorPart " + editorPart.getTitle() + " (type: " + editorPart.getClass().getSimpleName() + ") cannot provide a ModelConnector object."));
        }
        return null;
    }

    public static Optional<IModelConnector> getModelConnectorFromIEditorPartChecked(IEditorPart editorPart) {
        if (editorPart != null) {
            Object adaptedObject = editorPart.getAdapter(IModelConnector.class);
            if (adaptedObject != null) {
                return Optional.of((IModelConnector)adaptedObject);
            }
            return Optional.ofNullable((IModelConnector)Platform.getAdapterManager().loadAdapter((Object)editorPart, IModelConnector.class.getName()));
        }
        return Optional.empty();
    }
}

