/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;

public final class SingletonMemoryView<Value>
implements IMemoryView<Value> {
    private Value wrapped;
    private static final int ONE_HASH = Integer.valueOf(1).hashCode();

    public SingletonMemoryView(Value value) {
        this.wrapped = value;
    }

    @Override
    public Iterator<Value> iterator() {
        return new Iterator<Value>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Value next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return SingletonMemoryView.this.wrapped;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public int getCount(Value value) {
        return this.wrapped.equals(value) ? 1 : 0;
    }

    @Override
    public int getCountUnsafe(Object value) {
        return this.wrapped.equals(value) ? 1 : 0;
    }

    @Override
    public boolean containsNonZero(Value value) {
        return this.wrapped.equals(value);
    }

    @Override
    public boolean containsNonZeroUnsafe(Object value) {
        return this.wrapped.equals(value);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Set<Value> distinctValues() {
        return Collections.singleton(this.wrapped);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IMemoryView) {
            IMemoryView other = (IMemoryView)obj;
            if (1 != other.size()) {
                return false;
            }
            return 1 == other.getCountUnsafe(this.wrapped);
        }
        return false;
    }

    public int hashCode() {
        return this.wrapped.hashCode() ^ ONE_HASH;
    }

    public String toString() {
        return "{" + String.valueOf(this.wrapped) + "}";
    }
}

