/**
 * 
 *   Copyright (c) 2010-2013, Abel Hegedus, Zoltan Ujhelyi, Denes Harmath, Istvan Rath and Daniel Varro, IncQuery Labs Ltd.
 *   This program and the accompanying materials are made available under the
 *   terms of the Eclipse Public License v. 2.0 which is available at
 *   http://www.eclipse.org/legal/epl-v20.html.
 *   
 *   SPDX-License-Identifier: EPL-2.0
 *  
 */
package org.eclipse.viatra.integration.uml.derivedfeatures;

import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedPatternGroup;

/**
 * A pattern group formed of all public patterns defined in DerivedFeatures.vql.
 * 
 * <p>Use the static instance as any {@link interface org.eclipse.viatra.query.runtime.api.IQueryGroup}, to conveniently prepare
 * a VIATRA Query engine for matching all patterns originally defined in file DerivedFeatures.vql,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.viatra.integration.uml.derivedfeatures, the group contains the definition of the following patterns: <ul>
 * <li>actionInput</li>
 * <li>actionOutput</li>
 * <li>activityGroup</li>
 * <li>activityGroupInActivity</li>
 * <li>activityNode</li>
 * <li>activityNodeActivity</li>
 * <li>activityEdgeInGroup</li>
 * <li>activityGroupContainedEdge</li>
 * <li>activityGroupContainedNode</li>
 * <li>activityNodeInGroup</li>
 * <li>activityGroupSubgroup</li>
 * <li>activityGroupSuperGroup</li>
 * <li>classifierAttribute</li>
 * <li>classifierFeature</li>
 * <li>featureFeaturingClassifier</li>
 * <li>directedRelationshipSource</li>
 * <li>directedRelationshipTarget</li>
 * <li>elementOwnedElement</li>
 * <li>elementOwner</li>
 * <li>namespaceMember</li>
 * <li>namespaceOwnedMember</li>
 * <li>redefinableElementRedefinedElement</li>
 * <li>redefinableElementRedefinitionContext</li>
 * <li>relationshipRelatedElement</li>
 * <li>structuredClassifierRole</li>
 * <li>actionContext</li>
 * <li>associationEndType</li>
 * <li>behaviorContext</li>
 * <li>connectableElementEnd</li>
 * <li>deploymentTargetDeployedElement</li>
 * <li>namedElementClientDependency</li>
 * <li>protocolTransitionReferred</li>
 * <li>vertexIncoming</li>
 * <li>vertexOutgoing</li>
 * <li>connectorKind</li>
 * <li>messageMessageKind</li>
 * <li>packageNestedPackage</li>
 * <li>packageOwnedStereotype</li>
 * <li>packageOwnedType</li>
 * <li>propertyIsComposite</li>
 * <li>stateIsComposite</li>
 * <li>namedElementNamespace</li>
 * <li>typePackage</li>
 * <li>classExtension</li>
 * <li>classSuperClass</li>
 * <li>classifierGeneral</li>
 * <li>encapsulatedClassifierOwnedPort</li>
 * <li>extensionMetaclass</li>
 * <li>namedElementQualifiedName</li>
 * <li>namespaceImportedMember</li>
 * <li>opaqueExpressionResult</li>
 * <li>packageNestingPackage</li>
 * <li>redefinableTemplateSignatureInheritedParameter</li>
 * <li>structuredClassifierPart</li>
 * <li>stateIsOrthogonal</li>
 * </ul>
 * 
 * @see IQueryGroup
 * 
 */
@SuppressWarnings("all")
public final class DerivedFeatures extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws ViatraQueryRuntimeException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static DerivedFeatures instance() {
    if (INSTANCE == null) {
        INSTANCE = new DerivedFeatures();
    }
    return INSTANCE;
  }

  private static DerivedFeatures INSTANCE;

  private DerivedFeatures() {
    querySpecifications.add(ActionInput.instance());
    querySpecifications.add(ActionOutput.instance());
    querySpecifications.add(ActivityGroup.instance());
    querySpecifications.add(ActivityGroupInActivity.instance());
    querySpecifications.add(ActivityNode.instance());
    querySpecifications.add(ActivityNodeActivity.instance());
    querySpecifications.add(ActivityEdgeInGroup.instance());
    querySpecifications.add(ActivityGroupContainedEdge.instance());
    querySpecifications.add(ActivityGroupContainedNode.instance());
    querySpecifications.add(ActivityNodeInGroup.instance());
    querySpecifications.add(ActivityGroupSubgroup.instance());
    querySpecifications.add(ActivityGroupSuperGroup.instance());
    querySpecifications.add(ClassifierAttribute.instance());
    querySpecifications.add(ClassifierFeature.instance());
    querySpecifications.add(FeatureFeaturingClassifier.instance());
    querySpecifications.add(DirectedRelationshipSource.instance());
    querySpecifications.add(DirectedRelationshipTarget.instance());
    querySpecifications.add(ElementOwnedElement.instance());
    querySpecifications.add(ElementOwner.instance());
    querySpecifications.add(NamespaceMember.instance());
    querySpecifications.add(NamespaceOwnedMember.instance());
    querySpecifications.add(RedefinableElementRedefinedElement.instance());
    querySpecifications.add(RedefinableElementRedefinitionContext.instance());
    querySpecifications.add(RelationshipRelatedElement.instance());
    querySpecifications.add(StructuredClassifierRole.instance());
    querySpecifications.add(ActionContext.instance());
    querySpecifications.add(AssociationEndType.instance());
    querySpecifications.add(BehaviorContext.instance());
    querySpecifications.add(ConnectableElementEnd.instance());
    querySpecifications.add(DeploymentTargetDeployedElement.instance());
    querySpecifications.add(NamedElementClientDependency.instance());
    querySpecifications.add(ProtocolTransitionReferred.instance());
    querySpecifications.add(VertexIncoming.instance());
    querySpecifications.add(VertexOutgoing.instance());
    querySpecifications.add(ConnectorKind.instance());
    querySpecifications.add(MessageMessageKind.instance());
    querySpecifications.add(PackageNestedPackage.instance());
    querySpecifications.add(PackageOwnedStereotype.instance());
    querySpecifications.add(PackageOwnedType.instance());
    querySpecifications.add(PropertyIsComposite.instance());
    querySpecifications.add(StateIsComposite.instance());
    querySpecifications.add(NamedElementNamespace.instance());
    querySpecifications.add(TypePackage.instance());
    querySpecifications.add(ClassExtension.instance());
    querySpecifications.add(ClassSuperClass.instance());
    querySpecifications.add(ClassifierGeneral.instance());
    querySpecifications.add(EncapsulatedClassifierOwnedPort.instance());
    querySpecifications.add(ExtensionMetaclass.instance());
    querySpecifications.add(NamedElementQualifiedName.instance());
    querySpecifications.add(NamespaceImportedMember.instance());
    querySpecifications.add(OpaqueExpressionResult.instance());
    querySpecifications.add(PackageNestingPackage.instance());
    querySpecifications.add(RedefinableTemplateSignatureInheritedParameter.instance());
    querySpecifications.add(StructuredClassifierPart.instance());
    querySpecifications.add(StateIsOrthogonal.instance());
  }
}
