/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.internal.apiimpl.QueryResultWrapper;
import org.eclipse.viatra.query.runtime.matchers.backend.IMatcherCapability;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public abstract class BaseMatcher<Match extends IPatternMatch>
extends QueryResultWrapper
implements ViatraQueryMatcher<Match> {
    protected ViatraQueryEngine engine;
    protected IQuerySpecification<? extends BaseMatcher<Match>> querySpecification;
    private IMatcherCapability capabilities;
    private Object[] fEmptyArray;

    public BaseMatcher(IQuerySpecification<? extends BaseMatcher<Match>> querySpecification) {
        this.querySpecification = querySpecification;
        this.querySpecification.getInternalQueryRepresentation().ensureInitialized();
    }

    @Override
    protected void setBackend(ViatraQueryEngine engine, IQueryResultProvider resultProvider, IMatcherCapability capabilities) {
        this.backend = resultProvider;
        this.engine = engine;
        this.capabilities = capabilities;
    }

    protected abstract Match arrayToMatch(Object[] var1);

    protected abstract Match arrayToMatchMutable(Object[] var1);

    protected Object[] matchToArray(Match partialMatch) {
        return partialMatch.toArray();
    }

    protected abstract Match tupleToMatch(Tuple var1);

    protected Object[] emptyArray() {
        if (this.fEmptyArray == null) {
            this.fEmptyArray = new Object[this.getSpecification().getParameterNames().size()];
        }
        return this.fEmptyArray;
    }

    @Override
    public Integer getPositionOfParameter(String parameterName) {
        return this.getSpecification().getPositionOfParameter(parameterName);
    }

    @Override
    public List<String> getParameterNames() {
        return this.getSpecification().getParameterNames();
    }

    @Override
    public Collection<Match> getAllMatches() {
        return this.rawStreamAllMatches(this.emptyArray()).collect(Collectors.toSet());
    }

    @Override
    public Stream<Match> streamAllMatches() {
        return this.rawStreamAllMatches(this.emptyArray());
    }

    protected Stream<Match> rawStreamAllMatches(Object[] parameters) {
        return this.backend.getAllMatches(parameters).map(this::tupleToMatch);
    }

    @Override
    public Collection<Match> getAllMatches(Match partialMatch) {
        return this.rawStreamAllMatches(partialMatch.toArray()).collect(Collectors.toSet());
    }

    @Override
    public Stream<Match> streamAllMatches(Match partialMatch) {
        return this.rawStreamAllMatches(partialMatch.toArray());
    }

    @Override
    public Optional<Match> getOneArbitraryMatch() {
        return this.rawGetOneArbitraryMatch(this.emptyArray());
    }

    protected Optional<Match> rawGetOneArbitraryMatch(Object[] parameters) {
        return this.backend.getOneArbitraryMatch(parameters).map(this::tupleToMatch);
    }

    @Override
    public Optional<Match> getOneArbitraryMatch(Match partialMatch) {
        return this.rawGetOneArbitraryMatch(partialMatch.toArray());
    }

    protected boolean rawHasMatch(Object[] parameters) {
        return this.backend.hasMatch(parameters);
    }

    @Override
    public boolean hasMatch() {
        return this.rawHasMatch(this.emptyArray());
    }

    @Override
    public boolean hasMatch(Match partialMatch) {
        return this.rawHasMatch(partialMatch.toArray());
    }

    @Override
    public int countMatches() {
        return this.rawCountMatches(this.emptyArray());
    }

    protected int rawCountMatches(Object[] parameters) {
        return this.backend.countMatches(parameters);
    }

    @Override
    public int countMatches(Match partialMatch) {
        return this.rawCountMatches(partialMatch.toArray());
    }

    protected void rawForEachMatch(Object[] parameters, Consumer<? super Match> processor) {
        this.backend.getAllMatches(parameters).map(this::tupleToMatch).forEach(processor);
    }

    @Override
    public void forEachMatch(Consumer<? super Match> processor) {
        this.rawForEachMatch(this.emptyArray(), processor);
    }

    @Override
    public void forEachMatch(Match match, Consumer<? super Match> processor) {
        this.rawForEachMatch(match.toArray(), processor);
    }

    @Override
    public boolean forOneArbitraryMatch(Consumer<? super Match> processor) {
        return this.rawForOneArbitraryMatch(this.emptyArray(), processor);
    }

    @Override
    public boolean forOneArbitraryMatch(Match partialMatch, Consumer<? super Match> processor) {
        return this.rawForOneArbitraryMatch(partialMatch.toArray(), processor);
    }

    protected boolean rawForOneArbitraryMatch(Object[] parameters, Consumer<? super Match> processor) {
        return this.backend.getOneArbitraryMatch(parameters).map(this::tupleToMatch).map(m -> {
            processor.accept((Object)m);
            return true;
        }).orElse(false);
    }

    @Override
    public Match newEmptyMatch() {
        return this.arrayToMatchMutable(new Object[this.getParameterNames().size()]);
    }

    @Override
    public Match newMatch(Object ... parameters) {
        return this.arrayToMatch(parameters);
    }

    @Override
    public Set<Object> getAllValues(String parameterName) {
        return this.rawStreamAllValues(this.getPositionOfParameter(parameterName), this.emptyArray()).collect(Collectors.toSet());
    }

    @Override
    public Set<Object> getAllValues(String parameterName, Match partialMatch) {
        return this.rawStreamAllValues(this.getPositionOfParameter(parameterName), partialMatch.toArray()).collect(Collectors.toSet());
    }

    protected Stream<Object> rawStreamAllValues(int position, Object[] parameters) {
        Preconditions.checkElementIndex((int)position, (int)this.getParameterNames().size());
        Preconditions.checkArgument((parameters.length == this.getParameterNames().size() ? 1 : 0) != 0);
        return this.rawStreamAllMatches(parameters).map(match -> match.get(position));
    }

    protected <T> void rawAccumulateAllValues(int position, Object[] parameters, Set<T> accumulator) {
        this.rawForEachMatch(parameters, match -> {
            boolean bl = accumulator.add(match.get(position));
        });
    }

    @Override
    public ViatraQueryEngine getEngine() {
        return this.engine;
    }

    @Override
    public IQuerySpecification<? extends BaseMatcher<Match>> getSpecification() {
        return this.querySpecification;
    }

    @Override
    public String getPatternName() {
        return this.querySpecification.getFullyQualifiedName();
    }

    public IMatcherCapability getCapabilities() {
        return this.capabilities;
    }
}

