/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.model;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.viatra.addon.viewers.runtime.model.EventFilterBuilder;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerFilterDefinition;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.notation.Edge;
import org.eclipse.viatra.addon.viewers.runtime.notation.FormatSpecification;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;
import org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage;
import org.eclipse.viatra.addon.viewers.runtime.specifications.EdgeQuerySpecificationDescriptor;
import org.eclipse.viatra.addon.viewers.runtime.util.FormatParser;
import org.eclipse.viatra.addon.viewers.runtime.util.LabelParser;
import org.eclipse.viatra.query.runtime.api.GenericPatternMatch;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.views.core.ViewModelManager;
import org.eclipse.viatra.transformation.views.core.ViewModelRule;
import org.eclipse.viatra.transformation.views.core.util.ViewModelUtil;
import org.eclipse.viatra.transformation.views.traceability.generic.AbstractQuerySpecificationDescriptor;

public class EdgeRule
extends ViewModelRule {
    private final EdgeQuerySpecificationDescriptor descriptor;
    private final ViewerState state;
    private ViewerDataFilter filter;

    public EdgeRule(EdgeQuerySpecificationDescriptor descriptor, ViewerState state, ViewerDataFilter filter) {
        super((AbstractQuerySpecificationDescriptor)descriptor);
        this.descriptor = descriptor;
        this.state = state;
        this.filter = filter;
    }

    public static EdgeRule initiate(IQuerySpecification<?> specification, PAnnotation annotation, ViewerState state, ViewerDataFilter filter) {
        EdgeQuerySpecificationDescriptor descriptor = new EdgeQuerySpecificationDescriptor(specification, annotation);
        return new EdgeRule(descriptor, state, filter);
    }

    private EventFilter<IPatternMatch> createFilter(ViewerDataFilter baseFilter) {
        if (!baseFilter.isFiltered(this.getBaseSpecification())) {
            return null;
        }
        ViewerFilterDefinition filterDefinition = baseFilter.getFilter(this.getBaseSpecification());
        return EventFilterBuilder.createEventFilter(filterDefinition, this.getReferencedSpecification());
    }

    public Job<GenericPatternMatch> getAppearedJob() {
        return Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, match -> {
            String sourceParam = "trace<" + this.descriptor.getSource() + ">";
            String targetParam = "trace<" + this.descriptor.getTarget() + ">";
            Item source = (Item)match.get(sourceParam);
            Item target = (Item)match.get(targetParam);
            EObject eObject = ViewModelUtil.create((EClass)NotationPackage.eINSTANCE.getEdge(), (EObject)this.state.getNotationModel(), (EReference)NotationPackage.eINSTANCE.getNotationModel_Edges());
            ViewModelUtil.trace((ViewModelManager)this.state.getManager(), (String)this.getReferencedSpecification().getFullyQualifiedName(), Collections.singleton(eObject), (Object[])new Object[]{match.get(this.descriptor.getSource()), match.get(this.descriptor.getTarget())});
            Edge edge = (Edge)eObject;
            edge.setSource(source);
            edge.setTarget(target);
            edge.setLabel(LabelParser.calculateLabel(match, this.descriptor.getLabel()));
            if (this.descriptor.isFormatted()) {
                FormatSpecification formatSpecification = FormatParser.parseFormatAnnotation(this.descriptor.getFormatAnnotation());
                edge.setFormat(formatSpecification);
            }
            this.state.edgeAppeared(edge);
            this.logger.debug((Object)("Edge appeared: <" + this.getTracedSpecification().getFullyQualifiedName() + ">" + edge.toString()));
        }));
    }

    public Job<GenericPatternMatch> getDisappearedJob() {
        return Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, match -> {
            if (ViewModelUtil.target((GenericPatternMatch)match) instanceof Edge) {
                Collection edges = ViewModelUtil.delete((GenericPatternMatch)match);
                for (EObject edge : edges) {
                    this.state.edgeDisappeared((Edge)edge);
                    this.logger.debug((Object)("Edge disappeared: <" + this.getTracedSpecification().getFullyQualifiedName() + ">" + edge.toString()));
                }
            }
        }));
    }

    public Job<GenericPatternMatch> getUpdatedJob() {
        return Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, match -> {
            String newLabel;
            Edge edge;
            String oldLabel;
            if (ViewModelUtil.target((GenericPatternMatch)match) instanceof Edge && !(oldLabel = (edge = (Edge)ViewModelUtil.target((GenericPatternMatch)match)).getLabel()).equals(newLabel = LabelParser.calculateLabel(match, this.descriptor.getLabel()))) {
                edge.setLabel(newLabel);
                this.state.labelUpdated(edge, newLabel);
                this.logger.debug((Object)("Edge updated: <" + this.getTracedSpecification().getFullyQualifiedName() + ">" + edge.toString()));
            }
        }));
    }

    protected EventFilter<IPatternMatch> prepareFilter() {
        return this.createFilter(this.filter);
    }
}

