/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry.properties;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.properties.ParametersPropertySource;

public class QueryRegistryTreeEntryPropertySource
implements IPropertySource {
    private static final String PROPERTY_FQN = "fqn";
    private static final String PROPERTY_LOADED = "loaded";
    private static final String PROPERTY_PROJECT = "project";
    private static final String PROPERTY_SOURCE = "source";
    private static final String PROPERTY_PARAMETERS = "parameters";
    private final QueryRegistryTreeEntry entry;

    public QueryRegistryTreeEntryPropertySource(QueryRegistryTreeEntry adaptableObject) {
        this.entry = adaptableObject;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        String category = "Info";
        PropertyDescriptor fqnProperty = new PropertyDescriptor((Object)PROPERTY_FQN, "Fully qualified name");
        fqnProperty.setCategory(category);
        PropertyDescriptor sourceProperty = new PropertyDescriptor((Object)PROPERTY_SOURCE, "Source identifier");
        sourceProperty.setCategory(category);
        PropertyDescriptor projectProperty = new PropertyDescriptor((Object)PROPERTY_PROJECT, "Contributing project");
        projectProperty.setCategory(category);
        PropertyDescriptor loadedProperty = new PropertyDescriptor((Object)PROPERTY_LOADED, "Query specification loaded");
        loadedProperty.setCategory(category);
        PropertyDescriptor parametersProperty = new PropertyDescriptor((Object)PROPERTY_PARAMETERS, "Parameters");
        parametersProperty.setCategory(category);
        return new IPropertyDescriptor[]{fqnProperty, sourceProperty, projectProperty, loadedProperty, parametersProperty};
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(PROPERTY_FQN)) {
            return this.entry.getEntry().getFullyQualifiedName();
        }
        if (id.equals(PROPERTY_SOURCE)) {
            return this.entry.getEntry().getSourceIdentifier();
        }
        if (id.equals(PROPERTY_LOADED)) {
            return this.entry.isLoaded();
        }
        if (id.equals(PROPERTY_PROJECT)) {
            return this.entry.getEntry().getSourceProjectName();
        }
        if (id.equals(PROPERTY_PARAMETERS)) {
            if (this.entry.isLoaded()) {
                return new ParametersPropertySource(this.entry.getEntry());
            }
            return "Query specification not loaded";
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

