/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.queries;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.psystem.IQueryReference;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PTraceable;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameterDirection;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;

public final class PQueries {
    private PQueries() {
    }

    public static Predicate<PQuery> queryStatusPredicate(final PQuery.PQueryStatus status) {
        return new Predicate<PQuery>(){

            public boolean apply(PQuery query) {
                return query.getStatus().equals((Object)status);
            }
        };
    }

    public static Function<PQuery, String> queryNameFunction() {
        return new Function<PQuery, String>(){

            public String apply(PQuery query) {
                return query.getFullyQualifiedName();
            }
        };
    }

    public static Function<PParameter, String> parameterNameFunction() {
        return new Function<PParameter, String>(){

            public String apply(PParameter param) {
                return param.getName();
            }
        };
    }

    public static Function<IQueryReference, PQuery> queryOfReferenceFunction() {
        return new Function<IQueryReference, PQuery>(){

            public PQuery apply(IQueryReference reference) {
                return reference.getReferredQuery();
            }
        };
    }

    public static Function<PBody, Iterable<PQuery>> directlyReferencedQueriesFunction() {
        return new Function<PBody, Iterable<PQuery>>(){

            public Iterable<PQuery> apply(PBody body) {
                return Iterables.transform(body.getConstraintsOfType(IQueryReference.class), PQueries.queryOfReferenceFunction());
            }
        };
    }

    public static Predicate<PParameter> parameterDirectionPredicate(final PParameterDirection direction) {
        return new Predicate<PParameter>(){

            public boolean apply(PParameter input) {
                return input.getDirection() == direction;
            }
        };
    }

    public static Set<PTraceable> getTraceables(PQuery query) {
        Set<PBody> bodies = query.getDisjunctBodies().getBodies();
        Iterable constraints = Iterables.concat((Iterable)Iterables.transform(bodies, (Function)new Function<PBody, Iterable<PConstraint>>(){

            public Iterable<PConstraint> apply(PBody body) {
                return body.getConstraints();
            }
        }));
        return ImmutableSet.builder().add((Object)query).addAll(bodies).addAll(constraints).build();
    }
}

