/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryContentProvider;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryLabelProvider;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class VMDetailsDialog
extends Dialog {
    private IVMInstall fVM;

    public VMDetailsDialog(Shell shell, IVMInstall vm) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fVM = vm;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(JREMessages.VMDetailsDialog_0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, IJavaDebugHelpContextIds.JRE_DETAILS_DIALOG);
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = (Composite)super.createDialogArea(ancestor);
        GridLayout layout = new GridLayout(2, false);
        layout.makeColumnsEqualWidth = false;
        parent.setLayout((Layout)layout);
        this.createLabel(parent, JREMessages.addVMDialog_jreType);
        this.createLabel(parent, this.fVM.getVMInstallType().getName());
        this.createLabel(parent, JREMessages.addVMDialog_jreName);
        this.createLabel(parent, this.fVM.getName());
        this.createLabel(parent, JREMessages.addVMDialog_jreHome);
        this.createLabel(parent, this.fVM.getInstallLocation().getAbsolutePath());
        SWTFactory.createLabel((Composite)parent, (String)JREMessages.AddVMDialog_23, (int)2);
        String text = null;
        if (this.fVM instanceof IVMInstall2) {
            text = ((IVMInstall2)this.fVM).getVMArgs();
        } else {
            String[] args = this.fVM.getVMArguments();
            if (args != null) {
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < args.length) {
                    buf.append(args[i]);
                    if (i < args.length - 1) {
                        buf.append(" ");
                    }
                    ++i;
                }
                text = buf.toString();
            }
        }
        if (text == null) {
            text = "";
        }
        Text argText = SWTFactory.createText((Composite)parent, (int)2624, (int)2, (String)text);
        GridData gd = (GridData)argText.getLayoutData();
        gd.heightHint = 75;
        gd.widthHint = 300;
        SWTFactory.createLabel((Composite)parent, (String)JREMessages.AddVMDialog_JRE_system_libraries__1, (int)2);
        TreeViewer libraryViewer = new TreeViewer(parent);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 100;
        libraryViewer.getControl().setLayoutData((Object)gd);
        LibraryContentProvider provider = new LibraryContentProvider();
        libraryViewer.setContentProvider((IContentProvider)provider);
        libraryViewer.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider());
        libraryViewer.setInput((Object)this);
        provider.setLibraries(JavaRuntime.getLibraryLocations((IVMInstall)this.fVM));
        VMDetailsDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    protected String getDialogSettingsSectionName() {
        return "VM_DETAILS_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

