/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner.cost.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.IConstraintEvaluationContext;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.ICostFunction;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.context.InputKeyImplication;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.planning.helpers.FunctionalDependencyHelper;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.analysis.QueryAnalyzer;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.AggregatorConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;

public abstract class StatisticsBasedConstraintCostFunction
implements ICostFunction {
    protected static double MAX_COST = 250.0;
    protected static double DEFAULT_COST = MAX_COST - 100.0;

    public abstract long countTuples(IConstraintEvaluationContext var1, IInputKey var2);

    @Override
    public double apply(IConstraintEvaluationContext input) {
        try {
            return this.calculateCost(input.getConstraint(), input);
        }
        catch (QueryProcessingException e) {
            throw new RuntimeException("Error while calculating operation cost ", e);
        }
    }

    protected double _calculateCost(ConstantValue constant, IConstraintEvaluationContext input) throws QueryProcessingException {
        return 0.0;
    }

    protected double _calculateCost(TypeConstraint constraint, IConstraintEvaluationContext input) throws QueryProcessingException {
        Collection<PVariable> freeMaskVariables = input.getFreeVariables();
        Collection<PVariable> boundMaskVariables = input.getBoundVariables();
        IInputKey supplierKey = (IInputKey)constraint.getSupplierKey();
        long arity = supplierKey.getArity();
        if (arity == 1L) {
            return this.calculateUnaryConstraintCost(constraint, input);
        }
        if (arity == 2L) {
            long edgeCount = this.countTuples(input, supplierKey);
            PVariable srcVariable = (PVariable)constraint.getVariablesTuple().get(0);
            PVariable dstVariable = (PVariable)constraint.getVariablesTuple().get(1);
            boolean isInverse = false;
            if (freeMaskVariables.contains(srcVariable) && boundMaskVariables.contains(dstVariable)) {
                isInverse = true;
            }
            double binaryExtendCost = this.calculateBinaryExtendCost(supplierKey, srcVariable, dstVariable, isInverse, edgeCount, input);
            return isInverse ? binaryExtendCost + 1.0 : binaryExtendCost;
        }
        throw new UnsupportedOperationException("Cost calculation for arity " + arity + " is not implemented yet");
    }

    protected double calculateBinaryExtendCost(IInputKey supplierKey, PVariable srcVariable, PVariable dstVariable, boolean isInverse, long edgeCount, IConstraintEvaluationContext input) throws QueryProcessingException {
        double dstNodeCount;
        Collection<PVariable> freeMaskVariables = input.getFreeVariables();
        Collection<PVariable> boundMaskVariables = input.getBoundVariables();
        PConstraint constraint = input.getConstraint();
        IQueryMetaContext metaContext = input.getRuntimeContext().getMetaContext();
        QueryAnalyzer queryAnalyzer = input.getQueryAnalyzer();
        Collection implications = metaContext.getImplications(supplierKey);
        double srcCount = -1.0;
        double dstCount = -1.0;
        for (InputKeyImplication implication : implications) {
            List impliedIndices = implication.getImpliedIndices();
            if (impliedIndices.size() == 1 && impliedIndices.contains(0)) {
                srcCount = this.countTuples(input, implication.getImpliedKey());
                continue;
            }
            if (impliedIndices.size() != 1 || !impliedIndices.contains(1)) continue;
            dstCount = this.countTuples(input, implication.getImpliedKey());
        }
        if (freeMaskVariables.contains(srcVariable) && freeMaskVariables.contains(dstVariable)) {
            return dstCount * srcCount;
        }
        double srcNodeCount = isInverse ? dstCount : srcCount;
        double d = dstNodeCount = isInverse ? srcCount : dstCount;
        if (srcNodeCount > -1.0 && edgeCount > -1L) {
            if (srcNodeCount == 0.0) {
                return 0.0;
            }
            return (double)edgeCount / srcNodeCount;
        }
        if (srcCount > -1.0 && dstCount > -1.0) {
            if (srcCount != 0.0) {
                return dstNodeCount / srcNodeCount;
            }
            return 1.0;
        }
        Map functionalDependencies = queryAnalyzer.getFunctionalDependencies(Collections.unmodifiableSet(Sets.newHashSet((Object[])new PConstraint[]{constraint})), false);
        Set impliedVariables = FunctionalDependencyHelper.closureOf(boundMaskVariables, (Map)functionalDependencies);
        if (impliedVariables != null && impliedVariables.containsAll(freeMaskVariables)) {
            return 1.0;
        }
        return DEFAULT_COST;
    }

    protected double calculateUnaryConstraintCost(TypeConstraint constraint, IConstraintEvaluationContext input) throws QueryProcessingException {
        PVariable variable = (PVariable)constraint.getVariablesTuple().get(0);
        if (input.getBoundVariables().contains(variable)) {
            return 0.9;
        }
        return (double)this.countTuples(input, (IInputKey)constraint.getSupplierKey()) + DEFAULT_COST;
    }

    protected double _calculateCost(ExportedParameter exportedParam, IConstraintEvaluationContext input) throws QueryProcessingException {
        return 0.0;
    }

    protected double _calculateCost(TypeFilterConstraint exportedParam, IConstraintEvaluationContext input) throws QueryProcessingException {
        return 0.0;
    }

    protected double _calculateCost(PositivePatternCall patternCall, IConstraintEvaluationContext input) throws QueryProcessingException {
        Map dependencies = input.getQueryAnalyzer().getFunctionalDependencies((Set)ImmutableSet.of((Object)patternCall), false);
        Set boundOrImplied = FunctionalDependencyHelper.closureOf(input.getBoundVariables(), (Map)dependencies);
        List parameters = patternCall.getReferredQuery().getParameters();
        double result = 1.0;
        int i = 0;
        while (i < parameters.size()) {
            PVariable variable = patternCall.getVariableInTuple(i);
            IInputKey type = ((PParameter)parameters.get(i)).getDeclaredUnaryType();
            double multiplier = boundOrImplied.contains(variable) ? 0.9 : (type == null ? DEFAULT_COST : (double)this.countTuples(input, type));
            result *= multiplier;
            ++i;
        }
        return result;
    }

    protected double _calculateCost(ExpressionEvaluation evaluation, IConstraintEvaluationContext input) throws QueryProcessingException {
        return this._calculateCost((PConstraint)evaluation, input);
    }

    protected double _calculateCost(Inequality inequality, IConstraintEvaluationContext input) throws QueryProcessingException {
        return this._calculateCost((PConstraint)inequality, input);
    }

    protected double _calculateCost(AggregatorConstraint aggregator, IConstraintEvaluationContext input) throws QueryProcessingException {
        return this._calculateCost((PConstraint)aggregator, input);
    }

    protected double _calculateCost(NegativePatternCall call, IConstraintEvaluationContext input) throws QueryProcessingException {
        return this._calculateCost((PConstraint)call, input);
    }

    protected double _calculateCost(PatternMatchCounter counter, IConstraintEvaluationContext input) throws QueryProcessingException {
        return this._calculateCost((PConstraint)counter, input);
    }

    protected double _calculateCost(BinaryTransitiveClosure closure, IConstraintEvaluationContext input) throws QueryProcessingException {
        return this._calculateCost((PConstraint)closure, input);
    }

    protected double _calculateCost(PConstraint constraint, IConstraintEvaluationContext input) throws QueryProcessingException {
        boolean _isEmpty = input.getFreeVariables().isEmpty();
        if (_isEmpty) {
            return 1.0;
        }
        return DEFAULT_COST;
    }

    public double calculateCost(PConstraint constraint, IConstraintEvaluationContext input) throws QueryProcessingException {
        Preconditions.checkArgument((constraint != null ? 1 : 0) != 0, (Object)"Set constraint value correctly");
        if (constraint instanceof ExportedParameter) {
            return this._calculateCost((ExportedParameter)constraint, input);
        }
        if (constraint instanceof TypeFilterConstraint) {
            return this._calculateCost((TypeFilterConstraint)constraint, input);
        }
        if (constraint instanceof ConstantValue) {
            return this._calculateCost((ConstantValue)constraint, input);
        }
        if (constraint instanceof PositivePatternCall) {
            return this._calculateCost((PositivePatternCall)constraint, input);
        }
        if (constraint instanceof TypeConstraint) {
            return this._calculateCost((TypeConstraint)constraint, input);
        }
        if (constraint instanceof ExpressionEvaluation) {
            return this._calculateCost((ExpressionEvaluation)constraint, input);
        }
        if (constraint instanceof Inequality) {
            return this._calculateCost((Inequality)constraint, input);
        }
        if (constraint instanceof AggregatorConstraint) {
            return this._calculateCost((AggregatorConstraint)constraint, input);
        }
        if (constraint instanceof NegativePatternCall) {
            return this._calculateCost((NegativePatternCall)constraint, input);
        }
        if (constraint instanceof PatternMatchCounter) {
            return this._calculateCost((PatternMatchCounter)constraint, input);
        }
        if (constraint instanceof BinaryTransitiveClosure) {
            return this._calculateCost((BinaryTransitiveClosure)constraint, input);
        }
        return this._calculateCost(constraint, input);
    }
}

