/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.plan;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdaptable;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlan;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;

public class SearchPlanExecutor
implements ILocalSearchAdaptable {
    private int currentOperation;
    SearchPlan plan;
    private List<ISearchOperation> operations;
    private final ISearchContext context;
    private final List<ILocalSearchAdapter> adapters = Lists.newCopyOnWriteArrayList();
    private final BiMap<Integer, PVariable> variableMapping;

    public BiMap<Integer, PVariable> getVariableMapping() {
        return this.variableMapping;
    }

    public int getCurrentOperation() {
        return this.currentOperation;
    }

    public SearchPlan getSearchPlan() {
        return this.plan;
    }

    @Override
    public void addAdapters(List<ILocalSearchAdapter> adapters) {
        for (ILocalSearchAdapter adapter : adapters) {
            if (this.adapters.contains(adapter)) continue;
            this.adapters.add(adapter);
            adapter.adapterRegistered(this);
        }
    }

    @Override
    public void removeAdapters(List<ILocalSearchAdapter> adapters) {
        for (ILocalSearchAdapter adapter : adapters) {
            if (!this.adapters.remove(adapter)) continue;
            adapter.adapterUnregistered(this);
        }
    }

    public SearchPlanExecutor(SearchPlan plan, ISearchContext context, Map<PVariable, Integer> variableMapping) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Context cannot be null");
        this.plan = plan;
        this.context = context;
        this.variableMapping = HashBiMap.create(variableMapping).inverse();
        this.operations = plan.getOperations();
        this.currentOperation = -1;
    }

    private void init(MatchingFrame frame) throws LocalSearchException {
        if (this.currentOperation == -1) {
            ++this.currentOperation;
            ISearchOperation operation = this.operations.get(this.currentOperation);
            if (!this.adapters.isEmpty()) {
                for (ILocalSearchAdapter adapter : this.adapters) {
                    adapter.executorInitializing(this, frame);
                }
            }
            operation.onInitialize(frame, this.context);
        } else if (this.currentOperation == this.operations.size()) {
            --this.currentOperation;
        } else {
            throw new LocalSearchException("Error while executing search plan");
        }
    }

    public double cost() {
        return 0.0;
    }

    public boolean execute(MatchingFrame frame) throws LocalSearchException {
        boolean matchFound;
        int upperBound = this.operations.size() - 1;
        this.init(frame);
        this.operationSelected(frame);
        while (this.currentOperation >= 0 && this.currentOperation <= upperBound) {
            ISearchOperation operation;
            if (this.operations.get(this.currentOperation).execute(frame, this.context)) {
                this.operationExecuted(frame);
                ++this.currentOperation;
                this.operationSelected(frame);
                if (this.currentOperation > upperBound) continue;
                operation = this.operations.get(this.currentOperation);
                operation.onInitialize(frame, this.context);
                continue;
            }
            this.operationExecuted(frame);
            operation = this.operations.get(this.currentOperation);
            operation.onBacktrack(frame, this.context);
            --this.currentOperation;
            this.operationSelected(frame);
        }
        boolean bl = matchFound = this.currentOperation > upperBound;
        if (matchFound && !this.adapters.isEmpty()) {
            for (ILocalSearchAdapter adapter : this.adapters) {
                adapter.matchFound(this, frame);
            }
        }
        return matchFound;
    }

    public void resetPlan() {
        this.currentOperation = -1;
    }

    public void printDebugInformation() {
        int i = 0;
        while (i < this.operations.size()) {
            Logger.getRootLogger().debug((Object)("[" + i + "]\t" + this.operations.get(i).toString()));
            ++i;
        }
    }

    private void operationExecuted(MatchingFrame frame) {
        if (!this.adapters.isEmpty()) {
            for (ILocalSearchAdapter adapter : this.adapters) {
                adapter.operationExecuted(this, frame);
            }
        }
    }

    private void operationSelected(MatchingFrame frame) {
        if (!this.adapters.isEmpty()) {
            for (ILocalSearchAdapter adapter : this.adapters) {
                adapter.operationSelected(this, frame);
            }
        }
    }

    public ISearchContext getContext() {
        return this.context;
    }

    @Override
    public List<ILocalSearchAdapter> getAdapters() {
        return Collections.unmodifiableList(this.adapters);
    }

    @Override
    public void addAdapter(ILocalSearchAdapter adapter) {
        this.addAdapters(Collections.singletonList(adapter));
    }

    @Override
    public void removeAdapter(ILocalSearchAdapter adapter) {
        this.removeAdapters(Collections.singletonList(adapter));
    }

    public String toString() {
        if (this.operations == null) {
            return "Unspecified plan";
        }
        return Joiner.on((String)"\n").join(this.operations);
    }
}

