/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.MatchingFrameValueProvider;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.IValueProvider;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public class ExpressionEvalCheck
extends CheckOperation {
    private final int outputPosition;
    private final IExpressionEvaluator evaluator;
    private final Map<String, Integer> nameMap;

    public ExpressionEvalCheck(IExpressionEvaluator evaluator, Map<String, Integer> nameMap, int position) {
        this.evaluator = evaluator;
        this.nameMap = nameMap;
        this.outputPosition = position;
    }

    @Override
    public List<Integer> getVariablePositions() {
        ArrayList variables = Lists.newArrayList();
        variables.addAll(this.nameMap.values());
        return variables;
    }

    @Deprecated
    protected boolean check(MatchingFrame frame) throws LocalSearchException {
        return this.check(frame, null);
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        try {
            Object result = this.evaluator.evaluateExpression((IValueProvider)new MatchingFrameValueProvider(frame, this.nameMap));
            if (result != null) {
                Object currentValue = frame.get(this.outputPosition);
                return result.equals(currentValue);
            }
        }
        catch (Exception e) {
            Logger logger = ViatraQueryLoggingUtil.getLogger(this.getClass());
            logger.warn((Object)"Error while evaluating expression", (Throwable)e);
        }
        return false;
    }

    public String toString() {
        return "check     " + this.outputPosition + " = expression " + this.evaluator.getShortDescription();
    }
}

