/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.callhierarchy.IImplementorFinder;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class JavaImplementorFinder
implements IImplementorFinder {
    @Override
    public Collection<IType> findImplementingTypes(IType type, IProgressMonitor progressMonitor) {
        try {
            ITypeHierarchy typeHierarchy = type.newTypeHierarchy(progressMonitor);
            IType[] implementingTypes = typeHierarchy.getAllClasses();
            HashSet<IType> result = new HashSet<IType>(Arrays.asList(implementingTypes));
            return result;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    @Override
    public Collection<IType> findInterfaces(IType type, IProgressMonitor progressMonitor) {
        try {
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(progressMonitor);
            IType[] interfaces = typeHierarchy.getAllSuperInterfaces(type);
            HashSet<IType> result = new HashSet<IType>(Arrays.asList(interfaces));
            return result;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
    }
}

