/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.validators;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.addon.viewers.runtime.notation.HierarchyPolicy;
import org.eclipse.viatra.addon.viewers.runtime.validators.AbstractAnnotationValidator;
import org.eclipse.viatra.query.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.Annotation;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.PatternLanguagePackage;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.StringValue;
import org.eclipse.viatra.query.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.viatra.query.patternlanguage.validation.IIssueCallback;

public class ItemValidator
extends AbstractAnnotationValidator {
    public static final String HIERARCHY_LITERAL_ISSUE = "org.eclipse.viatra.query.viewers.hierarchyliteral";

    @Override
    public void executeAdditionalValidation(Annotation annotation, IIssueCallback validator) {
        super.executeAdditionalValidation(annotation, validator);
        ValueReference hierarchyRef = CorePatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)"hierarchy");
        if (hierarchyRef instanceof StringValue) {
            String value = ((StringValue)hierarchyRef).getValue();
            List valueList = Lists.transform(Arrays.asList(HierarchyPolicy.values()), (Function)new Function<HierarchyPolicy, String>(){

                public String apply(HierarchyPolicy policy) {
                    return policy.name().toLowerCase();
                }
            });
            if (!valueList.contains(value.toLowerCase())) {
                validator.error(String.format("Invalid hierarchy literal %s. Possible values are %s.", value, Iterables.toString((Iterable)valueList)), (EObject)hierarchyRef, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, HIERARCHY_LITERAL_ISSUE, new String[0]);
            }
        }
    }
}

