/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.StateMachine;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.queries.StateMachineMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.rules.AbstractRule;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.qrt.util.PriorityRuleSpecification;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class StateMachineMapping
extends AbstractRule<StateMachineMatch> {
    public StateMachineMapping(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public PriorityRuleSpecification<StateMachineMatch> getSpecification() {
        PriorityRuleSpecification _createPriorityRuleSpecification = this.createPriorityRuleSpecification();
        Procedures.Procedure1<PriorityRuleSpecification<StateMachineMatch>> _function = new Procedures.Procedure1<PriorityRuleSpecification<StateMachineMatch>>(){

            public void apply(PriorityRuleSpecification<StateMachineMatch> it) {
                try {
                    Job _appearedJob = StateMachineMapping.this.getAppearedJob();
                    Job _updateJob = StateMachineMapping.this.getUpdateJob();
                    Job _disappearedJob = StateMachineMapping.this.getDisappearedJob();
                    it.setRuleSpecification((RuleSpecification<StateMachineMatch>)Rules.newMatcherRuleSpecification((IQuerySpecification)StateMachineMapping.this.cpsXformM2M.getStateMachine(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob, _updateJob, _disappearedJob}))));
                    it.setPriority(3);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return (PriorityRuleSpecification)ObjectExtensions.operator_doubleArrow(_createPriorityRuleSpecification, (Procedures.Procedure1)_function);
    }

    private Job<StateMachineMatch> getAppearedJob() {
        IMatchProcessor<StateMachineMatch> _function = new IMatchProcessor<StateMachineMatch>(){

            public void process(final StateMachineMatch match) {
                try {
                    DeploymentApplication depApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter(StateMachineMapping.this.cpsXformM2M.getCps2depTrace(StateMachineMapping.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getAppInstance()), DeploymentApplication.class));
                    final String smId = match.getStateMachine().getIdentifier();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Mapping state machine with ID: ");
                    _builder.append((Object)smId);
                    StateMachineMapping.this.logger.debug((Object)_builder);
                    DeploymentBehavior _createDeploymentBehavior = StateMachineMapping.this.depFactory.createDeploymentBehavior();
                    Procedures.Procedure1<DeploymentBehavior> _function = new Procedures.Procedure1<DeploymentBehavior>(){

                        public void apply(DeploymentBehavior it) {
                            it.setDescription(smId);
                        }
                    };
                    final DeploymentBehavior behavior = (DeploymentBehavior)ObjectExtensions.operator_doubleArrow((Object)_createDeploymentBehavior, (Procedures.Procedure1)_function);
                    depApp.setBehavior(behavior);
                    Set<CPS2DeploymentTrace> traces = StateMachineMapping.this.cpsXformM2M.getCps2depTrace(StateMachineMapping.this.engine).getAllValuesOftrace(null, (Identifiable)match.getStateMachine(), null);
                    boolean _isEmpty = traces.isEmpty();
                    if (_isEmpty) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append((Object)"Creating new trace for state machine");
                        StateMachineMapping.this.logger.trace((Object)_builder_1);
                        EList _traces = StateMachineMapping.this.getRootMapping().getTraces();
                        CPS2DeploymentTrace _createCPS2DeploymentTrace = StateMachineMapping.this.traceFactory.createCPS2DeploymentTrace();
                        Procedures.Procedure1<CPS2DeploymentTrace> _function_1 = new Procedures.Procedure1<CPS2DeploymentTrace>(){

                            public void apply(CPS2DeploymentTrace it) {
                                EList _cpsElements = it.getCpsElements();
                                StateMachine _stateMachine = match.getStateMachine();
                                _cpsElements.add((Object)_stateMachine);
                                EList _deploymentElements = it.getDeploymentElements();
                                _deploymentElements.add((Object)behavior);
                            }
                        };
                        CPS2DeploymentTrace _doubleArrow = (CPS2DeploymentTrace)ObjectExtensions.operator_doubleArrow((Object)_createCPS2DeploymentTrace, (Procedures.Procedure1)_function_1);
                        _traces.add((Object)_doubleArrow);
                    } else {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append((Object)"Adding new behavior to existing trace");
                        StateMachineMapping.this.logger.trace((Object)_builder_2);
                        EList _deploymentElements = ((CPS2DeploymentTrace)IterableExtensions.head(traces)).getDeploymentElements();
                        _deploymentElements.add((Object)behavior);
                    }
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append((Object)"Mapped state machine with ID: ");
                    _builder_3.append((Object)smId);
                    StateMachineMapping.this.logger.debug((Object)_builder_3);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }

    private Job<StateMachineMatch> getUpdateJob() {
        IMatchProcessor<StateMachineMatch> _function = new IMatchProcessor<StateMachineMatch>(){

            public void process(StateMachineMatch match) {
                try {
                    final String smId = match.getStateMachine().getIdentifier();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Updating mapped state machine with ID: ");
                    _builder.append((Object)smId);
                    StateMachineMapping.this.logger.debug((Object)_builder);
                    Iterable depSMs = Iterables.filter(StateMachineMapping.this.cpsXformM2M.getCps2depTrace(StateMachineMapping.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getStateMachine()), DeploymentBehavior.class);
                    Procedures.Procedure1<DeploymentBehavior> _function = new Procedures.Procedure1<DeploymentBehavior>(){

                        public void apply(DeploymentBehavior it) {
                            boolean _notEquals;
                            String _description = it.getDescription();
                            boolean bl = _notEquals = !Objects.equal((Object)_description, (Object)smId);
                            if (_notEquals) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"ID changed to ");
                                _builder.append((Object)smId);
                                (this).StateMachineMapping.this.logger.trace((Object)_builder);
                                it.setDescription(smId);
                            }
                        }
                    };
                    IterableExtensions.forEach((Iterable)depSMs, (Procedures.Procedure1)_function);
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append((Object)"Updated mapped state machine with ID: ");
                    _builder_1.append((Object)smId);
                    StateMachineMapping.this.logger.debug((Object)_builder_1);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function);
    }

    private Job<StateMachineMatch> getDisappearedJob() {
        IMatchProcessor<StateMachineMatch> _function = new IMatchProcessor<StateMachineMatch>(){

            public void process(StateMachineMatch match) {
                try {
                    DeploymentElement _head = (DeploymentElement)IterableExtensions.head(StateMachineMapping.this.cpsXformM2M.getCps2depTrace(StateMachineMapping.this.engine).getAllValuesOfdepElement(null, null, (Identifiable)match.getAppInstance()));
                    DeploymentApplication depApp = (DeploymentApplication)_head;
                    DeploymentBehavior depBehavior = depApp.getBehavior();
                    String smId = depBehavior.getDescription();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Removing state machine with ID: ");
                    _builder.append((Object)smId);
                    StateMachineMapping.this.logger.debug((Object)_builder);
                    depApp.setBehavior(null);
                    CPS2DeploymentTrace smTrace = (CPS2DeploymentTrace)IterableExtensions.head(StateMachineMapping.this.cpsXformM2M.getCps2depTrace(StateMachineMapping.this.engine).getAllValuesOftrace(null, (Identifiable)match.getStateMachine(), null));
                    EList _deploymentElements = smTrace.getDeploymentElements();
                    _deploymentElements.remove((Object)depBehavior);
                    boolean _isEmpty = smTrace.getDeploymentElements().isEmpty();
                    if (_isEmpty) {
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append((Object)"Removing empty trace");
                        StateMachineMapping.this.logger.trace((Object)_builder_1);
                        EList _traces = StateMachineMapping.this.getRootMapping().getTraces();
                        _traces.remove((Object)smTrace);
                    }
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append((Object)"Removed state machine with ID: ");
                    _builder_2.append((Object)smId);
                    StateMachineMapping.this.logger.debug((Object)_builder_2);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function);
    }
}

