/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.generator.dtos;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystemPackage;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.generator.dtos.ModelStats;
import org.eclipse.viatra.examples.cps.generator.phases.CPSPhaseActionGeneration;
import org.eclipse.viatra.examples.cps.generator.queries.AllocatedAppInstancesMatcher;
import org.eclipse.viatra.examples.cps.generator.queries.AppInstancesMatcher;
import org.eclipse.viatra.examples.cps.generator.queries.AppTypesMatcher;
import org.eclipse.viatra.examples.cps.generator.queries.ConnectedHostsMatcher;
import org.eclipse.viatra.examples.cps.generator.queries.HostInstancesMatcher;
import org.eclipse.viatra.examples.cps.generator.queries.HostTypesMatcher;
import org.eclipse.viatra.examples.cps.generator.queries.StatesMatcher;
import org.eclipse.viatra.examples.cps.generator.queries.TransitionWithoutActionMatcher;
import org.eclipse.viatra.examples.cps.generator.queries.TransitionsMatcher;
import org.eclipse.viatra.examples.cps.generator.utils.StatsUtil;
import org.eclipse.viatra.examples.cps.generator.utils.SumProcessor;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.base.api.IEStructuralFeatureProcessor;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.base.api.ViatraBaseFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class CPSStats
extends ModelStats {
    private Logger logger = Logger.getLogger((String)"cps.generator.StatsUtil.CPSStats");
    public int appTypeCount = 0;
    public int appInstanceCount = 0;
    public int hostTypeCount = 0;
    public int hostInstanceCount = 0;
    public int stateCount = 0;
    public int transitionCount = 0;
    public int allocatedAppCount = 0;
    public int connectedHostCount = 0;
    public int sendActions = 0;
    public int waitActions = 0;
    public int emptyTransition = 0;
    public int duplicateIds = 0;

    public CPSStats(ViatraQueryEngine engine, CyberPhysicalSystem model) {
        try {
            this.appTypeCount = AppTypesMatcher.on(engine).countMatches();
            this.appInstanceCount = AppInstancesMatcher.on(engine).countMatches();
            this.hostTypeCount = HostTypesMatcher.on(engine).countMatches();
            this.hostInstanceCount = HostInstancesMatcher.on(engine).countMatches();
            this.stateCount = StatesMatcher.on(engine).countMatches();
            this.transitionCount = TransitionsMatcher.on(engine).countMatches();
            this.allocatedAppCount = AllocatedAppInstancesMatcher.on(engine).countMatches();
            this.connectedHostCount = ConnectedHostsMatcher.on(engine).countMatches();
            this.eObjects = IteratorExtensions.size((Iterator)model.eAllContents());
            this.eReferences = StatsUtil.countEdges((EObject)model);
            this.emptyTransition = TransitionWithoutActionMatcher.on(engine).countMatches();
            NavigationHelper baseIndex = ViatraBaseFactory.getInstance().createNavigationHelper((Notifier)model.eResource().getResourceSet(), true, this.logger);
            SumProcessor sp2 = new SumProcessor();
            baseIndex.processAllFeatureInstances((EStructuralFeature)CyberPhysicalSystemPackage.Literals.TRANSITION__ACTION, new IEStructuralFeatureProcessor(){

                public void process(EStructuralFeature feature, EObject source, Object target) {
                    if (source instanceof Transition) {
                        Transition t = (Transition)source;
                        boolean _startsWith = t.getAction().startsWith(CPSPhaseActionGeneration.SEND_METHOD_NAME);
                        if (_startsWith) {
                            ++CPSStats.this.sendActions;
                        } else {
                            boolean _startsWith_1 = t.getAction().startsWith(CPSPhaseActionGeneration.WAIT_METHOD_NAME);
                            if (_startsWith_1) {
                                ++CPSStats.this.waitActions;
                            }
                        }
                    }
                }
            });
            sp2.resetSum();
            Functions.Function1<ApplicationInstance, String> _function = new Functions.Function1<ApplicationInstance, String>(){

                public String apply(ApplicationInstance it) {
                    return it.getIdentifier();
                }
            };
            List appInstanceIdentifiers = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)baseIndex.getAllInstances(CyberPhysicalSystemPackage.Literals.APPLICATION_INSTANCE), ApplicationInstance.class), (Functions.Function1)_function));
            final LinkedHashSet uniqueAppInstanceIdentifiers = new LinkedHashSet();
            Procedures.Procedure1<String> _function_1 = new Procedures.Procedure1<String>(){

                public void apply(String it) {
                    boolean added = uniqueAppInstanceIdentifiers.add(it);
                    if (!added) {
                        ++CPSStats.this.duplicateIds;
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"Non-unique ApplicationInstance identifier: ");
                        _builder.append((Object)it);
                        CPSStats.this.logger.error((Object)_builder);
                    }
                }
            };
            IterableExtensions.forEach((Iterable)appInstanceIdentifiers, (Procedures.Procedure1)_function_1);
            baseIndex.dispose();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void log() {
        this.logger.info((Object)"====================================================================");
        this.logger.info((Object)"= CPS Stats: ");
        this.logger.info((Object)("=   ApplicationTypes: " + Integer.valueOf(this.appTypeCount)));
        this.logger.info((Object)("=   ApplicationInstances: " + Integer.valueOf(this.appInstanceCount)));
        this.logger.info((Object)("=   HostTypes: " + Integer.valueOf(this.hostTypeCount)));
        this.logger.info((Object)("=   HostInstances: " + Integer.valueOf(this.hostInstanceCount)));
        this.logger.info((Object)("=   States: " + Integer.valueOf(this.stateCount)));
        this.logger.info((Object)("=   Transitions: " + Integer.valueOf(this.transitionCount)));
        this.logger.info((Object)("=     Send: " + Integer.valueOf(this.sendActions)));
        this.logger.info((Object)("=     Wait: " + Integer.valueOf(this.waitActions)));
        this.logger.info((Object)("=     Without action: " + Integer.valueOf(this.emptyTransition)));
        this.logger.info((Object)("=   Allocated AppInstances: " + Integer.valueOf(this.allocatedAppCount)));
        this.logger.info((Object)("=   Connected HostsInstances: " + Integer.valueOf(this.connectedHostCount)));
        this.logger.info((Object)("=   EObjects: " + Integer.valueOf(this.eObjects)));
        this.logger.info((Object)("=   EReferences: " + Integer.valueOf(this.eReferences)));
        this.logger.info((Object)("=   Duplicate AppInstance IDs: " + Integer.valueOf(this.duplicateIds)));
        this.logger.info((Object)"====================================================================");
    }
}

