/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.util.CallInformation;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.AggregatorConstraint;
import org.eclipse.viatra.query.runtime.matchers.tuple.IModifiableTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileModifiableMaskedTuple;

public class AggregatorExtend
extends ExtendOperation
implements IPatternMatcherOperation {
    private final AggregatorConstraint aggregator;
    private final CallInformation information;
    private final VolatileModifiableMaskedTuple maskedTuple;
    private IQueryResultProvider matcher;

    public AggregatorExtend(CallInformation information, AggregatorConstraint aggregator, int position) {
        super(position);
        this.aggregator = aggregator;
        this.information = information;
        this.maskedTuple = new VolatileModifiableMaskedTuple(information.getThinFrameMask());
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        this.maskedTuple.updateTuple((IModifiableTuple)frame);
        this.matcher = context.getMatcher(this.information.getReference());
        Object aggregate = this.aggregate(this.aggregator.getAggregator().getOperator(), this.aggregator.getAggregatedColumn());
        this.it = aggregate == null ? Collections.emptyIterator() : Collections.singletonList(aggregate).iterator();
    }

    private <Domain, Accumulator, AggregateResult> AggregateResult aggregate(IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, int aggregatedColumn) {
        Object accumulator = operator.createNeutral();
        for (Tuple match : this.matcher.getAllMatches(this.information.getParameterMask(), (ITuple)this.maskedTuple)) {
            Object column = match.get(aggregatedColumn);
            accumulator = operator.update(accumulator, column, true);
        }
        return (AggregateResult)operator.getAggregate(accumulator);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.position);
    }

    public String toString() {
        return "extend    -" + this.position + " = " + this.aggregator.getAggregator().getOperator().getName() + " find " + this.information.toString();
    }
}

