/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Collections;
import java.util.List;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.util.CallInformation;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.IModifiableTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileModifiableMaskedTuple;

public class CountCheck
extends CheckOperation
implements IPatternMatcherOperation {
    private final int position;
    private final CallInformation information;
    private final VolatileModifiableMaskedTuple maskedTuple;
    private IQueryResultProvider matcher;

    public CountCheck(CallInformation information, int position) {
        this.information = information;
        this.position = position;
        this.maskedTuple = new VolatileModifiableMaskedTuple(information.getThinFrameMask());
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        super.onInitialize(frame, context);
        this.maskedTuple.updateTuple((IModifiableTuple)frame);
        this.matcher = context.getMatcher(this.information.getReference());
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) {
        int count = this.matcher.countMatches(this.information.getParameterMask(), (ITuple)this.maskedTuple);
        return (Integer)frame.getValue(this.position) == count;
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Collections.singletonList(this.position);
    }

    public String toString() {
        return "check     " + this.position + " = count find " + this.information.toString();
    }
}

