/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.mutable.primitive;

import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.factory.set.primitive.MutableDoubleSetFactory;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;

/**
 * MutableDoubleSetFactoryImpl is a factory implementation which creates instances of type {@link MutableDoubleSet}.
 * This file was automatically generated from template file mutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableDoubleSetFactoryImpl implements MutableDoubleSetFactory
{
    public MutableDoubleSet empty()
    {
        return new DoubleHashSet();
    }

    public MutableDoubleSet of()
    {
        return this.empty();
    }

    public MutableDoubleSet with()
    {
        return this.empty();
    }

    public MutableDoubleSet of(double... items)
    {
        return this.with(items);
    }

    public MutableDoubleSet with(double... items)
    {
        if (items == null || items.length == 0)
        {
            return this.empty();
        }
        return DoubleHashSet.newSetWith(items);
    }

    public MutableDoubleSet ofAll(DoubleIterable items)
    {
        return this.withAll(items);
    }

    public MutableDoubleSet withAll(DoubleIterable items)
    {
        return DoubleHashSet.newSet(items);
    }
}
