/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.UpdateMarkersOperation;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.MarkerViewHandler;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class MarkCompletedHandler
extends MarkerViewHandler {
    public Object execute(ExecutionEvent event) {
        ExecutionEvent finalEvent = event;
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, mon -> {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (String)MarkerMessages.markCompletedHandler_task, (int)100);
                IMarker[] markers = this.getSelectedMarkers(finalEvent);
                if (markers.length == 0) {
                    return;
                }
                HashMap<String, Boolean> attrs = new HashMap<String, Boolean>();
                attrs.put("done", Boolean.TRUE);
                UpdateMarkersOperation op = new UpdateMarkersOperation(markers, attrs, MarkerMessages.markCompletedAction_title, true);
                subMonitor.worked(20);
                this.execute((IUndoableOperation)op, MarkerMessages.markCompletedAction_title, (IProgressMonitor)subMonitor.split(80), null);
            });
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle(StatusUtil.newError(e), 1);
        }
        catch (InterruptedException e) {
            StatusManager.getManager().handle(StatusUtil.newStatus(2, e.getLocalizedMessage(), (Throwable)e), 1);
        }
        return this;
    }
}

