/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.perf;

import java.io.IOException;
import java.net.URL;
import java.util.EnumSet;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.tracecompass.analysis.os.linux.ui.swtbot.tests.perf.views.UiResponseTest;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfBenchmarkTrace;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class LttngUiResponseBenchmark
extends UiResponseTest {
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";

    protected void prepareWorkspace() {
        SWTBotUtils.switchToPerspective((String)"org.eclipse.linuxtools.lttng2.kernel.ui.perspective");
    }

    @Test
    public void testWithDjango() throws SecurityException, IllegalArgumentException, IOException {
        this.runTestWithTrace(FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.DJANGO_CLIENT.getTraceURL())).getAbsolutePath(), TRACE_TYPE, EnumSet.allOf(UiResponseTest.OsLinuxViews.class));
    }

    @Test
    public void testWithManyThreads() throws SecurityException, IllegalArgumentException, IOException {
        this.runTestWithTrace(FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.MANY_THREADS.getTraceURL())).getAbsolutePath(), TRACE_TYPE, EnumSet.of(UiResponseTest.OsLinuxViews.CONTROL_FLOW, UiResponseTest.OsLinuxViews.RESOURCES, UiResponseTest.OsLinuxViews.CPU_USAGE, UiResponseTest.OsLinuxViews.DISK_IO_ACTIVITY));
    }

    @Test
    public void testWithOsEvents() throws SecurityException, IllegalArgumentException {
        this.runTestWithTrace(CtfBenchmarkTrace.ALL_OS_ANALYSES.getTracePath().toString(), TRACE_TYPE, EnumSet.of(UiResponseTest.OsLinuxViews.CONTROL_FLOW, UiResponseTest.OsLinuxViews.RESOURCES, UiResponseTest.OsLinuxViews.CPU_USAGE, UiResponseTest.OsLinuxViews.DISK_IO_ACTIVITY));
    }
}

