/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader;

import java.util.List;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader.Uml2SDTestFacility;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.FilterCriteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.FilterListDialog;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDAdvancedPagingProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDPagingProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.loader.TmfUml2SDSyncLoader;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TmfUml2SDSyncLoaderExpTest {
    private static Uml2SDTestFacility fFacility;

    @BeforeClass
    public static void setUpClass() {
        fFacility = Uml2SDTestFacility.getInstance();
        fFacility.init();
        fFacility.createFilterCriteria();
        fFacility.selectExperiment();
    }

    @AfterClass
    public static void tearDownClass() {
        fFacility.disposeExperiment();
        fFacility.dispose();
        fFacility = null;
    }

    @Test
    public void verifySetup() {
        Assert.assertEquals((String)"getTitleString", (Object)"Component Interactions", (Object)fFacility.getLoader().getTitleString());
        Assert.assertEquals((String)"getPartName", (Object)"Sequence Diagram", (Object)fFacility.getSdView().getPartName());
        Assert.assertNotNull((String)"getFrame", (Object)fFacility.getSdView().getFrame());
        fFacility.disposeExperiment();
        fFacility.delay(1000L);
        TmfUml2SDSyncLoaderExpTest.verifyPage(0, 0, false, false, 0);
    }

    @Test
    public void verifyCancel() {
        int i = 0;
        while (i < 5) {
            fFacility.selectExperiment(false);
            fFacility.delay(1000L);
            try {
                fFacility.disposeExperiment();
                fFacility.getLoader().nextPage();
            }
            catch (Exception exception) {
                Assert.fail((String)"exp.select/exp.dispose");
            }
            ++i;
        }
    }

    @Test
    public void verifyDispose() {
        TmfUml2SDSyncLoaderExpTest.verifyPage(0, 0, false, false, 0);
        List filter = FilterListDialog.getGlobalFilters();
        for (FilterCriteria filterCriteria : filter) {
            Assert.assertFalse((String)"exp.dispose", (boolean)filterCriteria.isActive());
        }
    }

    @Test
    public void verifyLoaderDispose() {
        fFacility.getLoader().dispose();
        Assert.assertTrue((String)"loader.dispose", (fFacility.getSdView().getSDPagingProvider() == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"loader.dispose", (fFacility.getSdView().getSDFindProvider() == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"loader.dispose", (fFacility.getSdView().getSDFilterProvider() == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"loader.dispose", (fFacility.getSdView().getExtendedFindProvider() == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"loader.dispose", (fFacility.getSdView().getExtendedFilterProvider() == null ? 1 : 0) != 0);
        TmfSignalManager.register((Object)fFacility.getLoader());
    }

    @Test
    public void testSetViewer() {
        fFacility.getLoader().setViewer(fFacility.getSdView());
        ISDPagingProvider pagingProvider = fFacility.getSdView().getSDPagingProvider();
        Assert.assertTrue((String)"loader.setViewer", (pagingProvider != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"loader.setViewer", (boolean)(pagingProvider instanceof ISDAdvancedPagingProvider));
        Assert.assertTrue((String)"loader.setViewer", (boolean)(pagingProvider instanceof TmfUml2SDSyncLoader));
        Assert.assertTrue((String)"loader.setViewer", (fFacility.getSdView().getSDFindProvider() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"loader.setViewer", (fFacility.getSdView().getSDFilterProvider() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"loader.setViewer", (fFacility.getSdView().getExtendedFindProvider() == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"loader.setViewer", (fFacility.getSdView().getExtendedFilterProvider() == null ? 1 : 0) != 0);
    }

    private static void verifyPage(int currentPage, int numMsg, boolean hasNext, boolean hasPrev, int lifelineCount) {
        Assert.assertEquals((String)"currentPage", (long)currentPage, (long)fFacility.getLoader().currentPage());
        Assert.assertEquals((String)"syncMessageCount, ", (long)numMsg, (long)fFacility.getSdView().getFrame().syncMessageCount());
        if (hasNext) {
            Assert.assertTrue((String)"hasNextpage", (boolean)fFacility.getLoader().hasNextPage());
        } else {
            Assert.assertFalse((String)"hasNextPage", (boolean)fFacility.getLoader().hasNextPage());
        }
        if (hasPrev) {
            Assert.assertTrue((String)"hasPrevPage", (boolean)fFacility.getLoader().hasPrevPage());
        } else {
            Assert.assertFalse((String)"hasPrevPage", (boolean)fFacility.getLoader().hasPrevPage());
        }
        Assert.assertEquals((String)"lifeLinesCount", (long)lifelineCount, (long)fFacility.getSdView().getFrame().lifeLinesCount());
    }
}

