/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.util;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.internal.tmf.ui.util.LineClipper;
import org.junit.Assert;
import org.junit.Test;

public class LineClipperTest {
    @Test
    public void glancingTest() {
        Rectangle bounds = new Rectangle(0, 0, 638, 1119);
        int x0 = 1115;
        int y0 = -468;
        int x1 = 1132;
        int y1 = 42;
        Rectangle rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertNull((Object)rect);
    }

    @Test
    public void ousideSquareTest() {
        Rectangle bounds = new Rectangle(0, 0, 100, 100);
        int x0 = (int)(-Math.ceil(141.5));
        int y0 = 50;
        int x1 = 50;
        int y1 = (int)(-Math.ceil(141.5));
        Rectangle rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertNull((Object)rect);
        x0 = (int)(-Math.ceil(141.5));
        y0 = 150;
        x1 = 50;
        y1 = (int)Math.ceil(141.5);
        rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertNull((Object)rect);
        x0 = (int)Math.ceil(141.5);
        y0 = 50;
        x1 = 150;
        y1 = (int)(-Math.ceil(141.5));
        rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertNull((Object)rect);
        x0 = (int)Math.ceil(141.5);
        y0 = 150;
        x1 = 150;
        y1 = (int)Math.ceil(141.5);
        rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertNull((Object)rect);
    }

    @Test
    public void tangentTest() {
        Rectangle bounds = new Rectangle(0, 0, 1000, 1000);
        int x0 = -1;
        int y0 = -1;
        int x1 = 1000;
        int y1 = -1;
        Rectangle rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertNull((Object)rect);
    }

    @Test
    public void tangentInsideTest() {
        Rectangle bounds = new Rectangle(0, 0, 1000, 1000);
        int x0 = -1;
        int y0 = 0;
        int x1 = 1000;
        int y1 = 0;
        Rectangle rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertEquals((Object)new Rectangle(0, 0, 1000, 0), (Object)rect);
    }

    @Test
    public void tangentInsideCornerTest() {
        Rectangle bounds = new Rectangle(0, 0, 1000, 1000);
        int x0 = -1;
        int y0 = -1;
        int x1 = 1000;
        int y1 = 0;
        Rectangle rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertEquals((Object)new Rectangle(1000, 0, 0, 0), (Object)rect);
    }

    @Test
    public void clipTopTest() {
        Rectangle bounds = new Rectangle(0, 0, 1000, 1000);
        int x0 = 100;
        int y0 = 100;
        int x1 = 100;
        int y1 = 1000;
        Rectangle rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertEquals((Object)new Rectangle(100, 100, 0, 900), (Object)rect);
    }

    @Test
    public void clipLeftTest() {
        Rectangle bounds = new Rectangle(0, 0, 1000, 1000);
        int x0 = -100;
        int y0 = 100;
        int x1 = 100;
        int y1 = 100;
        Rectangle rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertEquals((Object)new Rectangle(0, 100, 100, 0), (Object)rect);
    }

    @Test
    public void clipBottomTest() {
        Rectangle bounds = new Rectangle(0, 0, 1000, 1000);
        int x0 = 100;
        int y0 = -100;
        int x1 = 100;
        int y1 = 1000;
        Rectangle rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertEquals((Object)new Rectangle(100, 0, 0, 1000), (Object)rect);
    }

    @Test
    public void clipRightTest() {
        Rectangle bounds = new Rectangle(0, 0, 1000, 1000);
        int x0 = 100;
        int y0 = 100;
        int x1 = 1100;
        int y1 = 100;
        Rectangle rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertEquals((Object)new Rectangle(100, 100, 900, 0), (Object)rect);
    }

    @Test
    public void clipXTest() {
        Rectangle bounds = new Rectangle(0, 0, 1000, 1000);
        int x0 = -100;
        int y0 = -100;
        int x1 = 1100;
        int y1 = 1100;
        Rectangle rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertEquals((Object)new Rectangle(0, 0, 1000, 1000), (Object)rect);
        x0 = 1100;
        y0 = -100;
        x1 = -100;
        y1 = 1100;
        rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertEquals((Object)new Rectangle(1000, 0, -1000, 1000), (Object)rect);
    }

    @Test
    public void insideTest() {
        Rectangle bounds = new Rectangle(0, 0, 1000, 1000);
        int x0 = 0;
        int y0 = 0;
        int x1 = 1000;
        int y1 = 1000;
        Rectangle rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertEquals((Object)new Rectangle(0, 0, 1000, 1000), (Object)rect);
    }

    @Test
    public void verticalTest() {
        Rectangle bounds = new Rectangle(0, 0, 1000, 1000);
        int x0 = 100;
        int y0 = -10000;
        int x1 = 100;
        int y1 = 10000;
        Rectangle rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertEquals((Object)new Rectangle(100, 0, 0, 1000), (Object)rect);
    }

    @Test
    public void horizontalTest() {
        Rectangle bounds = new Rectangle(0, 0, 1000, 1000);
        int x0 = 10000;
        int y0 = 100;
        int x1 = -100;
        int y1 = 100;
        Rectangle rect = LineClipper.clip((Rectangle)bounds, (int)x0, (int)y0, (int)x1, (int)y1);
        Assert.assertEquals((Object)new Rectangle(1000, 100, -1000, 0), (Object)rect);
    }
}

