/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.shared;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.model.TmfImportHelper;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.tests.shared.IWaitCondition;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitTimeoutException;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ProjectModelTestData {
    public static final String PROJECT_NAME = "Test_Project";
    private static final TmfTestTrace testTrace = TmfTestTrace.A_TEST_10K;

    public static TmfProjectElement getFilledProject() throws CoreException {
        IProject project = TmfProjectRegistry.createProject((String)PROJECT_NAME, null, null);
        TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
        TmfTraceFolder tracesFolder = projectElement.getTracesFolder();
        if (tracesFolder != null) {
            Path pathString;
            IFolder traceFolder = tracesFolder.getResource();
            IResource linkedTrace = TmfImportHelper.createLink((IFolder)traceFolder, (IPath)(pathString = new Path(testTrace.getFullPath())), (String)pathString.lastSegment());
            if (linkedTrace == null || !linkedTrace.exists()) {
                return null;
            }
            linkedTrace.setPersistentProperty(TmfCommonConstants.TRACETYPE, "org.eclipse.linuxtools.tmf.core.tests.tracetype");
            tracesFolder.refresh();
            TmfTraceElement traceElement = (TmfTraceElement)tracesFolder.getTraces().get(0);
            traceElement.refreshTraceType();
        }
        projectElement.refresh();
        return projectElement;
    }

    public static TmfExperimentElement addExperiment(TmfProjectElement projectElement, String experimentName) {
        TmfExperimentFolder experimentsFolder = projectElement.getExperimentsFolder();
        if (experimentsFolder != null) {
            IFolder experimentFolder = experimentsFolder.getResource();
            final IFolder folder = experimentFolder.getFolder(experimentName);
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                    monitor.beginTask("", 1000);
                    folder.create(false, true, monitor);
                    monitor.done();
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
            }
            catch (InterruptedException | RuntimeException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
            experimentsFolder.refresh();
            for (ITmfProjectModelElement el : experimentsFolder.getChildren()) {
                if (!el.getName().equals(experimentName) || !(el instanceof TmfExperimentElement)) continue;
                return (TmfExperimentElement)el;
            }
        }
        return null;
    }

    public static String getTraceName() {
        File file = new File(testTrace.getPath());
        String path = file.getAbsolutePath();
        IPath pathString = Path.fromOSString((String)path);
        return pathString.lastSegment();
    }

    public static void deleteProject(TmfProjectElement project) {
        TmfTraceFolder tracesFolder;
        int n;
        TmfExperimentFolder experimentsFolder = project.getExperimentsFolder();
        if (experimentsFolder != null) {
            ITmfProjectModelElement[] experiments;
            ITmfProjectModelElement[] iTmfProjectModelElementArray = experiments = experimentsFolder.getChildren().toArray(new ITmfProjectModelElement[0]);
            n = experiments.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfProjectModelElement element = iTmfProjectModelElementArray[n2];
                if (element instanceof TmfExperimentElement) {
                    TmfExperimentElement experiment = (TmfExperimentElement)element;
                    IFolder resource = experiment.getResource();
                    experiment.closeEditors();
                    IPath path = resource.getLocation();
                    if (path != null) {
                        experiment.deleteSupplementaryFolder();
                    }
                    try {
                        resource.delete(true, null);
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError("Error deleting experiment element", (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        if ((tracesFolder = project.getTracesFolder()) != null) {
            ITmfProjectModelElement[] traces;
            ITmfProjectModelElement[] iTmfProjectModelElementArray = traces = tracesFolder.getChildren().toArray(new ITmfProjectModelElement[0]);
            int n3 = traces.length;
            n = 0;
            while (n < n3) {
                ITmfProjectModelElement element = iTmfProjectModelElementArray[n];
                if (element instanceof TmfTraceElement) {
                    TmfTraceElement trace = (TmfTraceElement)element;
                    IResource resource = trace.getResource();
                    trace.closeEditors();
                    IPath path = resource.getLocation();
                    if (path != null) {
                        trace.deleteSupplementaryFolder();
                    }
                    try {
                        resource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError("Error deleting trace element", (Throwable)e);
                    }
                }
                ++n;
            }
        }
        try {
            project.getResource().delete(true, null);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error deleting project", (Throwable)e);
        }
    }

    public static void delayThread(long waitTimeMillis) {
        Display display = Display.getCurrent();
        if (display != null) {
            long endTimeMillis = System.currentTimeMillis() + waitTimeMillis;
            while (System.currentTimeMillis() < endTimeMillis) {
                if (!display.readAndDispatch()) {
                    display.sleep();
                }
                display.update();
            }
        } else {
            try {
                Thread.sleep(waitTimeMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void delayUntilTraceOpened(final TmfCommonProjectElement traceElement) throws WaitTimeoutException {
        WaitUtils.waitUntil(new IWaitCondition(){

            @Override
            public boolean test() throws Exception {
                return traceElement.getTrace() != null;
            }

            @Override
            public String getFailureMessage() {
                return "Timeout while waiting for " + traceElement;
            }
        });
    }
}

