/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.model.impl;

import org.eclipse.tracecompass.internal.lttng2.control.core.model.IBaseLoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceJulLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLog4jLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TracePythonLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.TraceInfo;

public class BaseLoggerInfo
extends TraceInfo
implements IBaseLoggerInfo {
    private ITraceLogLevel fLogLevel = TraceJulLogLevel.LEVEL_UNKNOWN;
    private TraceDomainType fDomain = TraceDomainType.UNKNOWN;

    public BaseLoggerInfo(String name) {
        super(name);
    }

    public BaseLoggerInfo(BaseLoggerInfo other) {
        super(other);
        this.fDomain = other.fDomain;
        this.fLogLevel = other.fLogLevel;
    }

    @Override
    public ITraceLogLevel getLogLevel() {
        return this.fLogLevel;
    }

    @Override
    public void setLogLevel(ITraceLogLevel level) {
        this.fLogLevel = level;
    }

    @Override
    public void setLogLevel(String levelName) {
        switch (this.fDomain) {
            case JUL: {
                this.fLogLevel = TraceJulLogLevel.valueOfString(levelName);
                break;
            }
            case LOG4J: {
                this.fLogLevel = TraceLog4jLogLevel.valueOfString(levelName);
                break;
            }
            case PYTHON: {
                this.fLogLevel = TracePythonLogLevel.valueOfString(levelName);
                break;
            }
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fDomain == null ? 0 : this.fDomain.hashCode());
        result = 31 * result + (this.fLogLevel == null ? 0 : this.fLogLevel.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseLoggerInfo other = (BaseLoggerInfo)obj;
        if (this.fDomain != other.fDomain) {
            return false;
        }
        return this.fLogLevel == other.fLogLevel;
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[BaseLoggerInfo(");
        output.append(super.toString());
        output.append(",domain=");
        output.append((Object)this.fDomain);
        output.append(",level=");
        output.append(this.fLogLevel);
        output.append(")]");
        return output.toString();
    }

    @Override
    public TraceDomainType getDomain() {
        return this.fDomain;
    }

    @Override
    public void setDomain(TraceDomainType domain) {
        this.fDomain = domain;
    }
}

