/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;

public class OperatorPrecedence {
    private static final int ASSIGNMENT = 0;
    private static final int CONDITIONAL = 1;
    private static final int CONDITIONAL_OR = 2;
    private static final int CONDITIONAL_AND = 3;
    private static final int BITWISE_INCLUSIVE_OR = 4;
    private static final int BITWISE_EXCLUSIVE_OR = 5;
    private static final int BITWISE_AND = 6;
    private static final int EQUALITY = 7;
    private static final int RATIONAL = 8;
    private static final int SHIFT = 9;
    private static final int ADDITIVE = 10;
    private static final int MULTIPLICATIVE = 11;
    private static final int PREFIX = 12;
    private static final int POSTFIX = 13;

    public static int getValue(Expression expression) {
        if (expression instanceof InfixExpression) {
            return OperatorPrecedence.getNormalizedValue((InfixExpression)expression);
        }
        if (expression instanceof PostfixExpression) {
            return OperatorPrecedence.getNormalizedValue((PostfixExpression)expression);
        }
        if (expression instanceof PrefixExpression) {
            return OperatorPrecedence.getNormalizedValue((PrefixExpression)expression);
        }
        if (expression instanceof Assignment) {
            return OperatorPrecedence.getNormalizedValue((Assignment)expression);
        }
        if (expression instanceof ConditionalExpression) {
            return OperatorPrecedence.getNormalizedValue((ConditionalExpression)expression);
        }
        if (expression instanceof InstanceofExpression) {
            return OperatorPrecedence.getNormalizedValue((InstanceofExpression)expression);
        }
        return -1;
    }

    private static int getNormalizedValue(Assignment ass) {
        return 0;
    }

    private static int getNormalizedValue(ConditionalExpression exp) {
        return 1;
    }

    private static int getNormalizedValue(InfixExpression exp) {
        InfixExpression.Operator operator = exp.getOperator();
        if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
            return 2;
        }
        if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
            return 3;
        }
        if (operator == InfixExpression.Operator.OR) {
            return 4;
        }
        if (operator == InfixExpression.Operator.XOR) {
            return 5;
        }
        if (operator == InfixExpression.Operator.AND) {
            return 6;
        }
        if (operator == InfixExpression.Operator.EQUALS || operator == InfixExpression.Operator.NOT_EQUALS) {
            return 7;
        }
        if (operator == InfixExpression.Operator.LESS || operator == InfixExpression.Operator.LESS_EQUALS || operator == InfixExpression.Operator.GREATER || operator == InfixExpression.Operator.GREATER_EQUALS) {
            return 8;
        }
        if (operator == InfixExpression.Operator.LEFT_SHIFT || operator == InfixExpression.Operator.RIGHT_SHIFT_SIGNED || operator == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED) {
            return 9;
        }
        if (operator == InfixExpression.Operator.PLUS || operator == InfixExpression.Operator.MINUS) {
            return 10;
        }
        if (operator == InfixExpression.Operator.REMAINDER || operator == InfixExpression.Operator.DIVIDE || operator == InfixExpression.Operator.TIMES) {
            return 11;
        }
        return -1;
    }

    private static int getNormalizedValue(InstanceofExpression exp) {
        return 8;
    }

    private static int getNormalizedValue(PrefixExpression exp) {
        return 12;
    }

    private static int getNormalizedValue(PostfixExpression exp) {
        return 13;
    }
}

