/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.DebugTracer;
import org.eclipse.ease.debugging.IScriptRegistry;
import org.eclipse.ease.debugging.dispatcher.EventDispatchJob;
import org.eclipse.ease.debugging.dispatcher.IEventProcessor;
import org.eclipse.ease.debugging.events.IDebugEvent;
import org.eclipse.ease.debugging.events.debugger.EngineStartedEvent;
import org.eclipse.ease.debugging.events.debugger.EngineTerminatedEvent;
import org.eclipse.ease.debugging.events.debugger.EvaluateExpressionEvent;
import org.eclipse.ease.debugging.events.debugger.ResumedEvent;
import org.eclipse.ease.debugging.events.debugger.ScriptReadyEvent;
import org.eclipse.ease.debugging.events.debugger.StackFramesEvent;
import org.eclipse.ease.debugging.events.debugger.SuspendedEvent;
import org.eclipse.ease.debugging.events.debugger.ThreadCreatedEvent;
import org.eclipse.ease.debugging.events.debugger.ThreadTerminatedEvent;
import org.eclipse.ease.debugging.events.debugger.VariablesEvent;
import org.eclipse.ease.debugging.events.model.BreakpointRequest;
import org.eclipse.ease.debugging.events.model.IModelRequest;
import org.eclipse.ease.debugging.model.EaseDebugElement;
import org.eclipse.ease.debugging.model.EaseDebugProcess;
import org.eclipse.ease.debugging.model.EaseDebugStackFrame;
import org.eclipse.ease.debugging.model.EaseDebugThread;

public abstract class EaseDebugTarget
extends EaseDebugElement
implements IDebugTarget,
IEventProcessor {
    private EventDispatchJob fDispatcher;
    private IScriptRegistry fScriptRegistry;
    private EaseDebugProcess fProcess = null;
    private final ILaunch fLaunch;
    private final boolean fSuspendOnStartup;
    private final boolean fSuspendOnScriptLoad;
    private final boolean fShowDynamicCode;
    private final List<Integer> fUniqueVariableIds = new ArrayList<Integer>();

    public EaseDebugTarget(ILaunch launch, boolean suspendOnStartup, boolean suspendOnScriptLoad, boolean showDynamicCode) {
        super(null);
        this.fLaunch = launch;
        this.fSuspendOnStartup = suspendOnStartup;
        this.fSuspendOnScriptLoad = suspendOnScriptLoad;
        this.fShowDynamicCode = showDynamicCode;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.fireCreationEvent();
    }

    public boolean isSuspendOnStartup() {
        return this.fSuspendOnStartup;
    }

    public boolean isSuspendOnScriptLoad() {
        return this.fSuspendOnScriptLoad;
    }

    public boolean isShowDynamicCode() {
        return this.fShowDynamicCode;
    }

    public String getName() {
        return "EASE Debugger";
    }

    @Override
    public EaseDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public EaseDebugProcess getProcess() {
        return this.fProcess;
    }

    public EaseDebugThread[] getThreads() {
        if (this.getProcess() != null) {
            return this.getProcess().getThreads();
        }
        return new EaseDebugThread[0];
    }

    public boolean hasThreads() {
        return this.getThreads().length > 0;
    }

    public void fireDispatchEvent(IModelRequest event) {
        if (this.fDispatcher != null) {
            this.fDispatcher.addEvent(event);
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void setDispatcher(EventDispatchJob dispatcher) {
        this.fDispatcher = dispatcher;
        this.setScriptRegistry(dispatcher);
    }

    public void setScriptRegistry(IScriptRegistry registry) {
        this.fScriptRegistry = registry;
    }

    @Override
    public synchronized void handleEvent(IDebugEvent event) {
        if (this.fDispatcher != null) {
            DebugTracer.debug("Model", "process " + event);
            if (event instanceof EngineStartedEvent) {
                this.fProcess = new EaseDebugProcess(this);
                this.fProcess.fireCreationEvent();
            } else if (event instanceof ScriptReadyEvent) {
                this.fProcess.handleEvent(event);
            } else if (event instanceof SuspendedEvent) {
                EaseDebugThread debugThread = this.getProcess().findDebugThread(((SuspendedEvent)event).getThread());
                if (debugThread == null) {
                    debugThread = this.getProcess().createDebugThread(((SuspendedEvent)event).getThread());
                }
                debugThread.handleEvent(event);
            } else if (event instanceof ResumedEvent) {
                EaseDebugThread debugThread = this.getProcess().findDebugThread(((ResumedEvent)event).getThread());
                if (debugThread != null) {
                    debugThread.handleEvent(event);
                }
            } else if (event instanceof StackFramesEvent) {
                EaseDebugThread debugThread = this.getProcess().findDebugThread(((StackFramesEvent)event).getThread());
                if (debugThread != null) {
                    debugThread.handleEvent(event);
                }
            } else if (event instanceof VariablesEvent) {
                EaseDebugStackFrame requestor = ((VariablesEvent)event).getRequestor();
                requestor.setVariables(((VariablesEvent)event).getVariables());
            } else if (event instanceof EvaluateExpressionEvent) {
                if (this.getThreads().length > 0) {
                    ((EvaluateExpressionEvent)event).getListener().watchEvaluationFinished(((EvaluateExpressionEvent)event).getWatchExpressionResult(this));
                }
            } else if (event instanceof ThreadCreatedEvent) {
                this.getProcess().handleEvent(event);
            } else if (event instanceof ThreadTerminatedEvent) {
                this.getProcess().handleEvent(event);
            } else if (event instanceof EngineTerminatedEvent) {
                this.cleanupOnTermination();
            }
        }
    }

    public void cleanupOnTermination() {
        this.fDispatcher = null;
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null) {
            debugPlugin.getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        }
        this.getProcess().setTerminated();
        EaseDebugThread[] easeDebugThreadArray = this.getThreads();
        int n = easeDebugThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            EaseDebugThread thread = easeDebugThreadArray[n2];
            thread.setStackFrames(Collections.emptyList());
            thread.setState(EaseDebugElement.State.TERMINATED);
            ++n2;
        }
        this.fireTerminateEvent();
    }

    public int getUniqueVariableId(Object value) {
        int hashCode = System.identityHashCode(value);
        int index = this.fUniqueVariableIds.indexOf(hashCode);
        if (index == -1) {
            this.fUniqueVariableIds.add(hashCode);
            index = this.fUniqueVariableIds.indexOf(hashCode);
        }
        return index;
    }

    protected abstract IBreakpoint[] getBreakpoints(Script var1);

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.handleBreakpointChange(breakpoint, BreakpointRequest.Mode.ADD);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.handleBreakpointChange(breakpoint, BreakpointRequest.Mode.REMOVE);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointRemoved(breakpoint, delta);
        this.breakpointAdded(breakpoint);
    }

    private synchronized void handleBreakpointChange(IBreakpoint breakpoint, BreakpointRequest.Mode mode) {
        Script script;
        IResource affectedResource = breakpoint.getMarker().getResource();
        if (this.fScriptRegistry != null && (script = this.fScriptRegistry.getScript(affectedResource)) != null) {
            this.fireDispatchEvent(new BreakpointRequest(script, breakpoint, mode));
            return;
        }
        EaseDebugThread[] easeDebugThreadArray = this.getThreads();
        int n = easeDebugThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            EaseDebugThread thread = easeDebugThreadArray[n2];
            IStackFrame[] iStackFrameArray = thread.getStackFrames();
            int n3 = iStackFrameArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Script script2;
                IStackFrame frame = iStackFrameArray[n4];
                if (frame instanceof EaseDebugStackFrame && affectedResource.equals((script2 = ((EaseDebugStackFrame)frame).getScript()).getFile())) {
                    this.fireDispatchEvent(new BreakpointRequest(script2, breakpoint, mode));
                }
                ++n4;
            }
            ++n2;
        }
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "org.eclipse.ease", "getMemoryBlock() not supported by " + this.getName()));
    }
}

