/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateValueCu;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

public class TmfXmlLocationCu {
    private final List<TmfXmlStateValueCu> fValues;

    TmfXmlLocationCu(List<TmfXmlStateValueCu> values) {
        this.fValues = values;
    }

    public List<TmfXmlStateValueCu> getValues() {
        return this.fValues;
    }

    public static @Nullable TmfXmlLocationCu compile(AnalysisCompilationData data, Element locationEl) {
        String id = locationEl.getAttribute("id");
        List<Element> childElements = TmfXmlUtils.getChildElements(locationEl, "stateAttribute");
        ArrayList<TmfXmlStateValueCu> children = new ArrayList<TmfXmlStateValueCu>();
        for (Element attribute : childElements) {
            List<TmfXmlStateValueCu> compiled = TmfXmlStateValueCu.compileAttribute(data, attribute);
            children.addAll(compiled);
        }
        if (children.isEmpty()) {
            Activator.logError("Location " + id + " is empty.");
            return null;
        }
        TmfXmlLocationCu location = new TmfXmlLocationCu(children);
        data.addLocation(id, location);
        return location;
    }
}

