/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.execution.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.building.AbstractTmfGraphProvider;
import org.eclipse.tracecompass.analysis.graph.core.building.ITraceEventHandler;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.IOsExecutionGraphHandlerBuilder;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsSystemModel;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.DefaultEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class OsExecutionGraphProvider
extends AbstractTmfGraphProvider {
    private static final String TMF_GRAPH_HANDLER_ID = "org.eclipse.tracecompass.analysis.os.linux.core.graph.handler";
    private static final String HANDLER = "handler";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_PRIORITY = "priority";
    private static final int DEFAULT_PRIORITY = 10;
    private final OsSystemModel fSystem = new OsSystemModel();

    public OsExecutionGraphProvider(ITmfTrace trace) {
        super(trace, "LTTng Kernel");
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_GRAPH_HANDLER_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                String elementName = ce.getName();
                if (HANDLER.equals(elementName)) {
                    IOsExecutionGraphHandlerBuilder builder;
                    try {
                        builder = (IOsExecutionGraphHandlerBuilder)ce.createExecutableExtension(ATTRIBUTE_CLASS);
                    }
                    catch (CoreException e1) {
                        Activator.getDefault().logWarning("Error create execution graph handler builder", e1);
                        break block6;
                    }
                    String priorityStr = ce.getAttribute(ATTRIBUTE_PRIORITY);
                    int priority = 10;
                    try {
                        priority = Integer.valueOf(priorityStr);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    ITraceEventHandler handler = builder.createHandler(this, priority);
                    this.registerHandler(handler);
                }
            }
            ++n2;
        }
    }

    public void done() {
        TmfGraph graph = this.getAssignedGraph();
        if (graph == null) {
            throw new NullPointerException();
        }
        Set keys = graph.getWorkers();
        ArrayList<OsWorker> kernelWorker = new ArrayList<OsWorker>();
        for (Object e : keys) {
            OsWorker w;
            if (!(e instanceof OsWorker) || (w = (OsWorker)e).getHostThread().getTid() != -1) continue;
            kernelWorker.add(w);
        }
        for (OsWorker osWorker : kernelWorker) {
            List nodes = graph.getNodesOf((IGraphWorker)osWorker);
            for (TmfVertex node : nodes) {
                TmfVertex next;
                TmfEdge nextV;
                TmfEdge nextH = node.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
                TmfEdge inV = node.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE);
                if (inV == null || nextH == null || (nextV = (next = nextH.getVertexTo()).getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE)) == null) continue;
                TmfVertex src = inV.getVertexFrom();
                TmfVertex dst = nextV.getVertexTo();
                node.removeEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE);
                next.removeEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE);
                src.linkVertical(dst).setType(inV.getType());
            }
        }
    }

    public IKernelAnalysisEventLayout getEventLayout(ITmfTrace trace) {
        if (trace instanceof IKernelTrace) {
            return ((IKernelTrace)trace).getKernelEventLayout();
        }
        return DefaultEventLayout.getInstance();
    }

    public OsSystemModel getSystem() {
        return this.fSystem;
    }

    public static enum Context {
        NONE,
        SOFTIRQ,
        IRQ,
        HRTIMER,
        IPI,
        COMPLETE_IRQ,
        PACKET_RECEPTION;

    }
}

